/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.ClaimedAttributes;
import de.bos_bremen.ci.asn1.x509.Attribute;
import de.bos_bremen.ci.asn1.x509.AttributeCertificate;
import java.util.ArrayList;
import java.util.List;

public class SignerAttribute
extends ANY {
    private List<ClaimedAttributes> claimedAttributes = new ArrayList<ClaimedAttributes>();
    private List<AttributeCertificate> certifiedAttributes = new ArrayList<AttributeCertificate>();

    public SignerAttribute(Run run) throws ParseException {
        super(run, false);
        if (run.next() != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos(), run.pos());
        }
        this.setEnd(run.readLength() + run.pos());
        while (run.pos() < this.getEnd()) {
            byte tag = run.next();
            if (ASN1.Factory.isTaggedAs(tag, 0)) {
                run.readLength();
                this.claimedAttributes.add(new ClaimedAttributes(run));
                continue;
            }
            if (ASN1.Factory.isTaggedAs(tag, 1)) {
                run.readLength();
                this.certifiedAttributes.add(new AttributeCertificate(run));
                continue;
            }
            throw new ParseException(this, "Wrong tag number", run.pos());
        }
    }

    public List<ClaimedAttributes> getClaimedAttributes() {
        return this.claimedAttributes;
    }

    public List<Attribute> getAllClaimedAttributes() {
        ArrayList<Attribute> allClaimedAttributes = new ArrayList<Attribute>();
        for (ClaimedAttributes claimedAttributeElement : this.claimedAttributes) {
            allClaimedAttributes.addAll(claimedAttributeElement.getAttributes());
        }
        return allClaimedAttributes;
    }

    public List<AttributeCertificate> getCertifiedAttributes() {
        return this.certifiedAttributes;
    }
}

