/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.CMSVersion;
import de.bos_bremen.ci.asn1.cms.CertificateSet;
import de.bos_bremen.ci.asn1.cms.DigestAlgorithmIdentifiers;
import de.bos_bremen.ci.asn1.cms.EncapsulatedContentInfo;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.bos_bremen.ci.asn1.cms.SignerInfos;
import de.bos_bremen.ci.asn1.crl.RevocationInfoChoices;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class SignedData
extends ANY
implements Dumpable {
    CMSVersion version;
    DigestAlgorithmIdentifiers digestAlgorithms;
    EncapsulatedContentInfo encapContentInfo;
    CertificateSet certificates;
    RevocationInfoChoices crls;
    SignerInfos signerInfos;

    public SignedData(Run _run) throws ParseException {
        super(_run, false);
        byte b;
        boolean indef;
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int len = _run.readLength();
        boolean bl = indef = len == -1;
        if (!indef) {
            this.setEnd(_run.pos() + len);
        }
        this.version = new CMSVersion(_run);
        this.digestAlgorithms = new DigestAlgorithmIdentifiers(_run);
        this.encapContentInfo = new EncapsulatedContentInfo(_run);
        if (indef && (b = _run.get()) == 0) {
            _run.next();
            _run.next();
            return;
        }
        tag = _run.get();
        if (ASN1.Factory.isTaggedConstructedAs(tag, 0)) {
            this.certificates = new CertificateSet(_run, true);
            tag = _run.get();
        }
        if (ASN1.Factory.isTaggedConstructedAs(tag, 1)) {
            this.crls = new RevocationInfoChoices(_run, true);
        }
        this.signerInfos = new SignerInfos(_run);
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public DigestAlgorithmIdentifiers getDigestAlgorithmIdentifiers() {
        return this.digestAlgorithms;
    }

    public EncapsulatedContentInfo getEncapsulatedContentInfo() {
        return this.encapContentInfo;
    }

    public void linkContent(File content) {
        this.encapContentInfo.linkContent(content);
    }

    public File getLinkedContent() {
        return this.encapContentInfo.getLinkedContent();
    }

    public boolean hasEnvelopedContent() {
        return this.encapContentInfo.getContent() != null;
    }

    public boolean hasDetachedContent() {
        return this.encapContentInfo.getLinkedContent() != null;
    }

    public boolean hasAnyContent() {
        return this.hasEnvelopedContent() || this.hasDetachedContent();
    }

    public CertificateSet getCertificates() {
        return this.certificates;
    }

    public RevocationInfoChoices getCRLs() {
        return this.crls;
    }

    public SignerInfos getSignerInfos() {
        return this.signerInfos;
    }

    public List<SignerInfo> getSignerInfoList() {
        return this.signerInfos.getSignerInfos();
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.version.toString());
        w.newLine();
        this.digestAlgorithms.dump(w);
        w.newLine();
        this.encapContentInfo.dump(w);
        if (this.certificates != null) {
            w.newLine();
            this.certificates.dump(w);
        }
        if (this.crls != null) {
            w.newLine();
            w.write(this.crls.getValueAsString());
        }
        w.newLine();
        this.signerInfos.dump(w);
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

