/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SignedAttributes
extends ANY {
    Map<OBJECTIDENTIFIER, List<SignedAttribute>> attributes;

    public SignedAttributes(Run _run, boolean implizit) throws ParseException {
        super(_run, implizit);
        byte tag = _run.next();
        if (!implizit && tag != 49) {
            throw new ParseException(this, ASN1.Factory.toString((byte)49) + " expected at index " + _run.pos(), _run.pos());
        }
        this.attributes = new HashMap<OBJECTIDENTIFIER, List<SignedAttribute>>();
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        while (_run.pos() < end) {
            SignedAttribute a = new SignedAttribute(_run);
            List<SignedAttribute> list = this.attributes.get(a.getType());
            if (list == null) {
                list = new ArrayList<SignedAttribute>();
                this.attributes.put(a.getType(), list);
            }
            this.attributes.get(a.getType()).add(a);
        }
    }

    public Map<OBJECTIDENTIFIER, List<SignedAttribute>> getAttributes() {
        return this.attributes;
    }

    public ANY getValue(OBJECTIDENTIFIER _oid) {
        List<ANY> values = this.getValues(_oid);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public List<ANY> getValues(OBJECTIDENTIFIER _oid) {
        List<SignedAttribute> a = this.attributes.get(_oid);
        if (a == null) {
            return null;
        }
        ArrayList<ANY> values = new ArrayList<ANY>();
        for (SignedAttribute sa : a) {
            values.addAll(sa.getValues());
        }
        if (values.isEmpty()) {
            return null;
        }
        return values;
    }

    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.attributes.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<Map.Entry<OBJECTIDENTIFIER, List<SignedAttribute>>> iter = this.attributes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<OBJECTIDENTIFIER, List<SignedAttribute>> entry = iter.next();
                List<SignedAttribute> a = entry.getValue();
                Iterator<SignedAttribute> aIter = a.iterator();
                while (aIter.hasNext()) {
                    aIter.next().dump(w);
                    if (!aIter.hasNext()) continue;
                    w.newLine();
                }
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }
}

