/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AbstractString;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.SEQUENCE;
import de.bos_bremen.ci.asn1.Time;
import de.bos_bremen.ci.asn1.cms.CommitmentTypeIndication;
import de.bos_bremen.ci.asn1.cms.ContentType;
import de.bos_bremen.ci.asn1.cms.SignaturePolicyIdentifier;
import de.bos_bremen.ci.asn1.cms.SignerAttribute;
import de.bos_bremen.ci.asn1.cms.SignerAttributeV2;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.bos_bremen.ci.asn1.cms.SignerLocation;
import de.bos_bremen.ci.asn1.tsp.SigningCertificate;
import de.bos_bremen.ci.asn1.x509.Attribute;
import de.bos_bremen.ci.asn1.x509.AttributeCertificate;
import java.io.IOException;
import java.util.Iterator;

public class SignedAttribute
extends Attribute {
    public static final OBJECTIDENTIFIER contentType = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.3");
    public static final OBJECTIDENTIFIER messageDigest = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.4");
    public static final OBJECTIDENTIFIER signingTime = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.5");
    public static final OBJECTIDENTIFIER counterSignature = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.6");
    public static final OBJECTIDENTIFIER signingCertificate = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.12");
    public static final OBJECTIDENTIFIER SIGNATURE_POLICY_IDENTIFIER = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.15");
    public static final OBJECTIDENTIFIER COMMITMENT_TYPE = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.16");
    public static final OBJECTIDENTIFIER SIGNER_LOCATION = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.17");
    public static final OBJECTIDENTIFIER SIGNER_ATTRIBUTES = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.18");
    public static final OBJECTIDENTIFIER SIGNER_ATTRIBUTES_V2 = OBJECTIDENTIFIER.valueOf("0.4.0.19122.1.1");
    public static final OBJECTIDENTIFIER SIGNING_CERTIFICATE_V2 = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.47");
    public static final OBJECTIDENTIFIER friendlyName = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.20");
    public static final OBJECTIDENTIFIER attributeCertificate = OBJECTIDENTIFIER.valueOf("2.5.4.58");
    public static final OBJECTIDENTIFIER ATTRIBUTE_CERTIFICATE_REFS = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.44");
    public static final OBJECTIDENTIFIER ATTRIBUTE_REVOCATION_REFS = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.16.2.45");
    public static final OBJECTIDENTIFIER LONG_TERM_VALIDATION = OBJECTIDENTIFIER.valueOf("0.4.0.1733.2.2");
    public static final OBJECTIDENTIFIER CMS_ALGORITHM_PROTECTION = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.9.52");

    public SignedAttribute(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public ANY forOID(OBJECTIDENTIFIER type, Run run) throws ParseException {
        if (contentType.equals(type)) {
            return new OBJECTIDENTIFIER(run);
        }
        if (messageDigest.equals(type)) {
            return new OCTETSTRING(run);
        }
        if (signingTime.equals(type)) {
            return (ANY)((Object)Time.Factory.generate(run));
        }
        if (counterSignature.equals(type)) {
            return new SignerInfo(run);
        }
        if (signingCertificate.equals(type)) {
            return new SigningCertificate(run, SigningCertificate.Version.V1);
        }
        if (SIGNING_CERTIFICATE_V2.equals(type)) {
            return new SigningCertificate(run, SigningCertificate.Version.V2);
        }
        if (friendlyName.equals(type)) {
            return AbstractString.generate(run);
        }
        if (attributeCertificate.equals(type)) {
            return new AttributeCertificate(run);
        }
        if (SIGNER_ATTRIBUTES.equals(type)) {
            return new SignerAttribute(run);
        }
        if (SIGNER_ATTRIBUTES_V2.equals(type)) {
            return new SignerAttributeV2(run);
        }
        if (SIGNER_LOCATION.equals(type)) {
            return new SignerLocation(run);
        }
        if (COMMITMENT_TYPE.equals(type)) {
            return new CommitmentTypeIndication(run);
        }
        if (SIGNATURE_POLICY_IDENTIFIER.equals(type)) {
            return SignaturePolicyIdentifier.Factory.generate(run);
        }
        if (ATTRIBUTE_CERTIFICATE_REFS.equals(type) || ATTRIBUTE_REVOCATION_REFS.equals(type) || LONG_TERM_VALIDATION.equals(type) || CMS_ALGORITHM_PROTECTION.equals(type)) {
            return new SEQUENCE(run);
        }
        return super.forOID(type, run);
    }

    public static String nameFor(OBJECTIDENTIFIER _oid) {
        if (contentType.equals(_oid)) {
            return "contentType";
        }
        if (messageDigest.equals(_oid)) {
            return "messageDigest";
        }
        if (signingTime.equals(_oid)) {
            return "signingTime";
        }
        if (counterSignature.equals(_oid)) {
            return "counterSignature";
        }
        if (signingCertificate.equals(_oid)) {
            return "signingCertificate";
        }
        if (friendlyName.equals(_oid)) {
            return "friendlyName";
        }
        if (attributeCertificate.equals(_oid)) {
            return "attributeCertificate";
        }
        if (CONTENT_TIME_STAMP.equals(_oid)) {
            return "id-aa-ets-contentTimestamp";
        }
        if (SIGNER_ATTRIBUTES.equals(_oid)) {
            return "id-aa-ets-signerAttr";
        }
        if (SIGNER_ATTRIBUTES_V2.equals(_oid)) {
            return "id-aa-ets-signerAttrV2";
        }
        if (SIGNING_CERTIFICATE_V2.equals(_oid)) {
            return "signingCertificateV2";
        }
        if (SIGNER_LOCATION.equals(_oid)) {
            return "id-aa-ets-signerLocation";
        }
        if (COMMITMENT_TYPE.equals(_oid)) {
            return "id-aa-ets-commitmentType";
        }
        if (SIGNATURE_POLICY_IDENTIFIER.equals(_oid)) {
            return "id-aa-ets-sigPolicyId";
        }
        if (CMS_ALGORITHM_PROTECTION.equals(_oid)) {
            return "id-aa-CMSAlgorithmProtection";
        }
        return Attribute.nameFor(_oid);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(SignedAttribute.nameFor(this.type) + " (" + this.type.toString() + ")");
        w.write(32);
        w.write(58);
        w.indent();
        w.newLine();
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            ANY any = (ANY)iterator.next();
            if (any instanceof OBJECTIDENTIFIER) {
                w.write(ContentType.nameFor((OBJECTIDENTIFIER)any) + " (" + any + ")");
            } else if (any instanceof OCTETSTRING) {
                w.write(any.getValueAsString());
            } else if (any instanceof Dumpable) {
                Dumpable d = (Dumpable)((Object)any);
                d.dump(w);
            } else {
                w.write(any.toString());
            }
            if (!iterator.hasNext()) continue;
            w.newLine();
        }
        w.outdent();
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

