/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.IA5String;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import de.bos_bremen.ci.asn1.cms.OtherHashAlgAndValue;
import de.bos_bremen.ci.asn1.cms.SPUserNotice;
import de.bos_bremen.ci.asn1.cms.SigPolicyQualifierInfo;
import de.bos_bremen.ci.asn1.cms.SignaturePolicyIdentifier;
import java.util.ArrayList;
import java.util.List;

public class SignaturePolicyId
extends ANY
implements SignaturePolicyIdentifier {
    private OBJECTIDENTIFIER sigPolicyId;
    private OtherHashAlgAndValue sigPolicyHash;
    private List<SigPolicyQualifierInfo> sigPolicyQualifiers = new ArrayList<SigPolicyQualifierInfo>();

    public SignaturePolicyId(Run run) throws ParseException {
        super(run, false);
        if (run.next() != 48) {
            throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
        }
        int l = run.readLength();
        this.setEnd(run.pos() + l);
        this.sigPolicyId = new OBJECTIDENTIFIER(run);
        this.sigPolicyHash = new OtherHashAlgAndValue(run);
        if (run.pos() >= this.getEnd()) {
            return;
        }
        if (run.next() != 48) {
            throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
        }
        run.readLength();
        do {
            this.sigPolicyQualifiers.add(new SigPolicyQualifierInfo(run));
        } while (run.pos() < this.getEnd());
    }

    public OBJECTIDENTIFIER getSigPolicyId() {
        return this.sigPolicyId;
    }

    public OtherHashAlgAndValue getSigPolicyHash() {
        return this.sigPolicyHash;
    }

    public List<SigPolicyQualifierInfo> getSigPolicyQualifiers() {
        return this.sigPolicyQualifiers;
    }

    public String getDisplayText() {
        String displayText;
        StringBuilder sb = new StringBuilder();
        String userNoticeAsString = null;
        String uri = null;
        for (SigPolicyQualifierInfo info : this.getSigPolicyQualifiers()) {
            SPUserNotice userNotice;
            CharString explicitText;
            ANY sigQualifier = info.getSigQualifier();
            if (sigQualifier instanceof SPUserNotice && (explicitText = (userNotice = (SPUserNotice)sigQualifier).getExplicitText()) != null) {
                userNoticeAsString = explicitText.getValueAsString();
            }
            if (sigQualifier instanceof IA5String) {
                IA5String string = (IA5String)sigQualifier;
                uri = string.getValueAsString();
            }
            if (userNoticeAsString == null || sigQualifier == null) continue;
            break;
        }
        if (userNoticeAsString != null) {
            sb.append(userNoticeAsString);
            sb.append(", ");
        }
        if (uri != null) {
            sb.append(uri);
            sb.append(", ");
        }
        if (this.getSigPolicyId() != null) {
            sb.append(this.getSigPolicyId().getOID());
            sb.append(", ");
        }
        if ((displayText = sb.toString()).endsWith(", ")) {
            displayText = displayText.substring(0, displayText.length() - 2);
        }
        return displayText;
    }
}

