/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import de.bos_bremen.ci.asn1.x509.DisplayText;
import de.bos_bremen.ci.asn1.x509.NoticeReference;

public class SPUserNotice
extends ANY {
    private NoticeReference noticeRef;
    private CharString explicitText;

    public SPUserNotice(Run run) throws ParseException {
        super(run, false);
        if (run.next() != 48) {
            throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
        }
        this.setEnd(run.readLength() + run.pos());
        if (run.pos() >= this.getEnd()) {
            return;
        }
        if (run.get() == 48) {
            this.noticeRef = new NoticeReference(run);
        }
        if (run.pos() <= this.getEnd()) {
            this.explicitText = DisplayText.Factory.createDisplayText(run);
        }
    }

    public NoticeReference getNoticeRef() {
        return this.noticeRef;
    }

    public CharString getExplicitText() {
        return this.explicitText;
    }
}

