/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import java.io.IOException;

public class OtherHashAlgAndValue
extends ANY
implements Dumpable {
    private AlgorithmIdentifier hashAlgorithm;
    private OCTETSTRING hashValue;

    public OtherHashAlgAndValue(Run run) throws ParseException {
        super(run, false);
        if (run.next() != 48) {
            throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
        }
        this.setLength(run.readLength());
        this.hashAlgorithm = new AlgorithmIdentifier(run);
        this.hashValue = new OCTETSTRING(run);
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public OCTETSTRING getHashValue() {
        return this.hashValue;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("hashAlgorithm: " + this.hashAlgorithm.getOID());
        w.newLine();
        w.write("hashValue: #" + this.hashValue.getValueAsHexedString());
        w.outdent();
        w.newLine();
        w.write(125);
    }
}

