/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.SignerIdentifier;
import de.bos_bremen.ci.asn1.x509.CertificateSerialNumber;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.Name;
import java.io.IOException;

public class IssuerAndSerialNumber
extends ANY
implements SignerIdentifier {
    Name issuer;
    CertificateSerialNumber serialNumber;

    public static IssuerAndSerialNumber newInstance(FlatCertificate cert) {
        IssuerAndSerialNumber is = new IssuerAndSerialNumber();
        is.issuer = cert.getIssuer();
        is.serialNumber = cert.getSerialNumber();
        return is;
    }

    private IssuerAndSerialNumber() {
    }

    public IssuerAndSerialNumber(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.issuer = new Name(_run);
        this.serialNumber = new CertificateSerialNumber(_run);
    }

    public Name getIssuer() {
        return this.issuer;
    }

    public CertificateSerialNumber getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.issuer.toString());
        w.newLine();
        w.write(this.serialNumber.toString());
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public boolean matches(FlatCertificate fc) {
        Name issuer2 = fc.getIssuer();
        CertificateSerialNumber serialNumber2 = fc.getSerialNumber();
        boolean b1 = this.issuer.matches(issuer2);
        boolean b2 = this.serialNumber.getValue().equals(serialNumber2.getValue());
        if (!b1) {
            return false;
        }
        return b2;
    }

    @Override
    public String getDisplayName() {
        return this.issuer.getOrganisation();
    }
}

