/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.LengthOutputStream;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.StreamUtil;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.ContentType;
import de.bos_bremen.ci.asn1.tsp.TSTInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncapsulatedContentInfo
extends ANY {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncapsulatedContentInfo.class);
    private ContentType eContentType;
    private ANY eContent;
    private File detachedContent;

    public EncapsulatedContentInfo(Run _run) throws ParseException {
        super(_run, false);
        byte b;
        int end;
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int len = _run.readLength();
        boolean indef = len == -1;
        int n = end = indef ? -1 : _run.pos() + len;
        if (!indef) {
            this.setEnd(end);
        }
        this.eContentType = new ContentType(_run);
        if (indef && (b = _run.get()) == 0) {
            _run.next();
            _run.next();
            this.setEnd(_run.pos());
            return;
        }
        if (indef || _run.pos() < end) {
            byte b2;
            tag = _run.next();
            if (!ASN1.Factory.isTaggedConstructed(tag)) {
                throw new ParseException(this, "TAGGED expected at index " + _run.pos(), _run.pos());
            }
            int len2 = _run.readLength();
            boolean indef2 = len2 == -1;
            this.eContent = this.generateContent(this.eContentType, _run);
            if (indef2 && (b2 = _run.get()) == 0) {
                _run.next();
                _run.next();
            }
        }
        if (indef && (b = _run.get()) == 0) {
            _run.next();
            _run.next();
            this.setEnd(_run.pos());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ANY generateContent(ContentType _contentType, Run _run) throws ParseException {
        if (_contentType.equals(ContentType.id_ct_TSTInfo)) {
            _run.next();
            _run.readLength();
            boolean indef = false;
            if (_run.get() != 48) {
                _run.next();
                _run.readLength();
                indef = true;
            }
            try {
                TSTInfo tSTInfo = new TSTInfo(_run);
                return tSTInfo;
            }
            finally {
                if (indef) {
                    _run.next();
                    _run.next();
                }
            }
        }
        return new OCTETSTRING(_run);
    }

    public OBJECTIDENTIFIER getContentType() {
        return this.eContentType;
    }

    public File getLinkedContent() {
        return this.detachedContent;
    }

    public ANY getContent() {
        return this.eContent;
    }

    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(ContentType.nameFor(this.eContentType) + " (" + this.eContentType + ")");
        if (this.eContent != null) {
            w.newLine();
            ((Dumpable)((Object)this.eContent)).dump(w);
        } else if (this.detachedContent != null) {
            w.newLine();
            w.write("File(" + this.detachedContent.length() + ")[" + this.detachedContent.getAbsolutePath() + "]");
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public byte[] getDigest(String _digAlg, String _provider) {
        MessageDigest md;
        if (this.eContent instanceof OCTETSTRING) {
            return ((OCTETSTRING)this.eContent).getFingerPrint(_digAlg, _provider);
        }
        if (this.eContent instanceof TSTInfo) {
            try {
                TSTInfo tstInfo = (TSTInfo)this.eContent;
                MessageDigest md2 = _provider == null ? MessageDigest.getInstance(_digAlg) : MessageDigest.getInstance(_digAlg, _provider);
                return md2.digest(tstInfo.asByteArray());
            }
            catch (Exception ex) {
                LOGGER.error("Cannot calculate hash of TSTInfo", (Throwable)ex);
                return null;
            }
        }
        if (this.eContent == null) {
            return null;
        }
        try {
            md = _provider == null ? MessageDigest.getInstance(_digAlg) : MessageDigest.getInstance(_digAlg, _provider);
        }
        catch (Exception ex) {
            LOGGER.error("Cannot get MessageDigest instance.", (Throwable)ex);
            return null;
        }
        try (DigestOutputStream digestOut = new DigestOutputStream(new LengthOutputStream(), md);
             InputStream is = Run.create(this.eContent.getSource(), this.getOffset()).stream(this.getLength());){
            StreamUtil.read(is, digestOut);
        }
        catch (IOException e) {
            LOGGER.error("Error while calculating hash for eContent.", (Throwable)e);
            return null;
        }
        return md.digest();
    }

    public void writeContentOctets(OutputStream _os) throws IOException {
        if (_os == null) {
            return;
        }
        if (this.eContent instanceof OCTETSTRING) {
            ((OCTETSTRING)this.eContent).writeOctets(_os);
            return;
        }
        if (this.detachedContent == null) {
            return;
        }
        FileInputStream is = new FileInputStream(this.detachedContent);
        try {
            StreamUtil.read((InputStream)is, _os);
        }
        finally {
            StreamUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContentOctets(Signature _sig) throws IOException, SignatureException {
        if (_sig == null) {
            return;
        }
        if (this.eContent instanceof OCTETSTRING) {
            ((OCTETSTRING)this.eContent).writeOctets(_sig);
            return;
        }
        if (this.detachedContent == null) {
            return;
        }
        FileInputStream is = new FileInputStream(this.detachedContent);
        try {
            byte[] buf = new byte[8192];
            int read = ((InputStream)is).read(buf);
            while (read != -1) {
                _sig.update(buf, 0, read);
                read = ((InputStream)is).read(buf);
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(OutputStream _os) throws IOException {
        if (_os == null) {
            return;
        }
        if (this.eContent instanceof OCTETSTRING) {
            ((OCTETSTRING)this.eContent).writeContent(_os);
            return;
        }
        if (this.detachedContent == null) {
            return;
        }
        FileInputStream is = new FileInputStream(this.detachedContent);
        try {
            byte[] buf = new byte[8192];
            int read = ((InputStream)is).read(buf);
            while (read != -1) {
                _os.write(buf, 0, read);
                read = ((InputStream)is).read(buf);
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(Signature _sig) throws IOException, SignatureException {
        if (_sig == null) {
            return;
        }
        if (this.eContent instanceof OCTETSTRING) {
            ((OCTETSTRING)this.eContent).writeContent(_sig);
            return;
        }
        if (this.detachedContent == null) {
            return;
        }
        FileInputStream is = new FileInputStream(this.detachedContent);
        try {
            byte[] buf = new byte[8192];
            int read = ((InputStream)is).read(buf);
            while (read != -1) {
                _sig.update(buf, 0, read);
                read = ((InputStream)is).read(buf);
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void linkContent(File _content) {
        this.detachedContent = _content;
    }
}

