/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DigestInfo
extends ANY {
    AlgorithmIdentifier algorithmIdentifier;
    OCTETSTRING digest;

    public DigestInfo(Run _run) throws ParseException {
        this(_run, false);
    }

    public DigestInfo(Run _run, boolean implizit) throws ParseException {
        super(_run, implizit);
        int tag = _run.next() & 0xFF;
        if (tag != 48) {
            throw new ParseException("", ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        this.setLength(_run.readLength());
        this.algorithmIdentifier = new AlgorithmIdentifier(_run);
        this.digest = new OCTETSTRING(_run, implizit);
    }

    public DigestInfo(AlgorithmIdentifier _algorithmIdentifier, OCTETSTRING _digest) {
        this.algorithmIdentifier = _algorithmIdentifier;
        this.digest = _digest;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public OCTETSTRING getDigest() {
        return this.digest;
    }

    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.algorithmIdentifier.dump(w);
        w.write(this.digest.toString());
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        os.write(48);
        int l = this.algorithmIdentifier.getLength();
        INTEGER.writeLength(os, l += this.digest.getLength());
        this.algorithmIdentifier.encode(os);
        this.digest.encode(os);
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.encode(os);
        return os.toByteArray();
    }
}

