/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DigestAlgorithmIdentifiers
extends ANY {
    Set<AlgorithmIdentifier> AlgorithmIdentifier;

    public DigestAlgorithmIdentifiers(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 49) {
            throw new ParseException(this, ASN1.Factory.toString((byte)49) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.AlgorithmIdentifier = new HashSet<AlgorithmIdentifier>();
        while (_run.pos() < end) {
            AlgorithmIdentifier ai = new AlgorithmIdentifier(_run);
            this.AlgorithmIdentifier.add(ai);
        }
    }

    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.AlgorithmIdentifier.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<AlgorithmIdentifier> iter = this.AlgorithmIdentifier.iterator();
            while (iter.hasNext()) {
                AlgorithmIdentifier ai = iter.next();
                ai.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }
}

