/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import de.bos_bremen.ci.asn1.cms.CommitmentTypeIdentifier;
import de.bos_bremen.ci.asn1.cms.CommitmentTypeQualifier;
import java.util.ArrayList;
import java.util.List;

public class CommitmentTypeIndication
extends ANY {
    private CommitmentTypeIdentifier commitmentTypeId;
    private List<CommitmentTypeQualifier> commitmentTypeQualifier = new ArrayList<CommitmentTypeQualifier>();

    public CommitmentTypeIndication(Run run) throws ParseException {
        super(run, false);
        if (run.next() != 48) {
            throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
        }
        this.setEnd(run.readLength() + run.pos());
        this.commitmentTypeId = new CommitmentTypeIdentifier(run);
        if (run.pos() >= this.getEnd()) {
            return;
        }
        if (run.next() != 48) {
            throw new UnexpectedASN1ObjectException((ANY)this, 48, run.pos());
        }
        run.readLength();
        do {
            this.commitmentTypeQualifier.add(new CommitmentTypeQualifier(run));
        } while (run.pos() < this.getEnd());
    }

    public CommitmentTypeIdentifier getCommitmentTypeId() {
        return this.commitmentTypeId;
    }

    public List<CommitmentTypeQualifier> getCommitmentTypeQualifier() {
        return this.commitmentTypeQualifier;
    }

    @Override
    public int hashCode() {
        int hashCode = this.getCommitmentTypeId().hashCode();
        for (CommitmentTypeQualifier qualifier : this.getCommitmentTypeQualifier()) {
            hashCode += qualifier.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof CommitmentTypeIndication)) {
            return false;
        }
        CommitmentTypeIndication other = (CommitmentTypeIndication)o;
        if (!this.getCommitmentTypeId().equals(other.getCommitmentTypeId())) {
            return false;
        }
        if (this.getCommitmentTypeQualifier().size() != other.getCommitmentTypeQualifier().size()) {
            return false;
        }
        for (int i = 0; i < this.getCommitmentTypeQualifier().size(); ++i) {
            if (this.getCommitmentTypeQualifier().get(i).equals(other.getCommitmentTypeQualifier().get(i))) continue;
            return false;
        }
        return true;
    }
}

