/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;

public class CommitmentTypeIdentifier
extends OBJECTIDENTIFIER {
    public static final CommitmentTypeIdentifier PROOF_OF_ORIGIN = CommitmentTypeIdentifier.newInstance("1.2.840.113549.1.9.16.6.1");
    public static final CommitmentTypeIdentifier PROOF_OF_RECEIPT = CommitmentTypeIdentifier.newInstance("1.2.840.113549.1.9.16.6.2");
    public static final CommitmentTypeIdentifier PROOF_OF_DELIVERY = CommitmentTypeIdentifier.newInstance("1.2.840.113549.1.9.16.6.3");
    public static final CommitmentTypeIdentifier PROOF_OF_SENDER = CommitmentTypeIdentifier.newInstance("1.2.840.113549.1.9.16.6.4");
    public static final CommitmentTypeIdentifier PROOF_OF_APPROVAL = CommitmentTypeIdentifier.newInstance("1.2.840.113549.1.9.16.6.5");
    public static final CommitmentTypeIdentifier PROOF_OF_CREATION = CommitmentTypeIdentifier.newInstance("1.2.840.113549.1.9.16.6.6");

    public CommitmentTypeIdentifier(Run run) throws ParseException {
        super(run);
    }

    public CommitmentTypeIdentifier(String oid) throws ParseException {
        super(oid);
    }

    private static CommitmentTypeIdentifier newInstance(String oid) {
        try {
            byte[] tlv = CommitmentTypeIdentifier.createTLVStructureFor(oid);
            CommitmentTypeIdentifier result = new CommitmentTypeIdentifier(Run.create(new BSource(tlv), 0));
            return result;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

