/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AttributeCertificate;

public class CertifiedAttributesV2
extends ANY {
    private AttributeCertificate attributeCertificate;

    public CertifiedAttributesV2(Run run) throws ParseException {
        super(run, false);
        if (run.next() != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos(), run.pos());
        }
        this.setEnd(run.readLength() + run.pos());
        while (run.pos() < this.getEnd()) {
            byte tag = run.next();
            if (ASN1.Factory.isTaggedAs(tag, 0)) {
                run.readLength();
                this.attributeCertificate = new AttributeCertificate(run);
                continue;
            }
            if (ASN1.Factory.isTaggedAs(tag, 1)) {
                ASN1.Factory.generate(run);
                continue;
            }
            throw new ParseException(this, "Wrong tag number", run.pos());
        }
    }

    public AttributeCertificate getAttributeCertificate() {
        return this.attributeCertificate;
    }
}

