/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.SignerIdentifier;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.CertificateSerialNumber;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.GeneralNames;
import de.bos_bremen.ci.asn1.x509.ext.AuthorityKeyIdentifierExtension;
import de.bos_bremen.ci.asn1.x509.ext.SubjectKeyIdentifierExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CertificateSet
extends ANY {
    private List<FlatCertificate> certificateChoices;

    public CertificateSet(Run _run, boolean implizit) throws ParseException {
        super(_run, implizit);
        int end;
        byte tag = _run.next();
        if (!implizit && tag != 49) {
            throw new ParseException(this, ASN1.Factory.toString((byte)49) + " expected at index " + _run.pos(), _run.pos());
        }
        int len = _run.readLength();
        boolean indef = len == -1;
        int n = end = indef ? -1 : _run.pos() + len;
        if (!indef) {
            this.setEnd(end);
        }
        this.certificateChoices = new ArrayList<FlatCertificate>();
        while (indef || _run.pos() < end) {
            byte b;
            FlatCertificate cc = FlatCertificate.Factory.generateCertificateSet(_run);
            this.certificateChoices.add(cc);
            if (!indef || (b = _run.get()) != 0) continue;
            _run.next();
            _run.next();
            return;
        }
    }

    public List<FlatCertificate> getCertificateChoices() {
        return this.certificateChoices;
    }

    public List<FlatCertificate> getMatchingCertificates(SignerIdentifier sid) {
        ArrayList<FlatCertificate> result = new ArrayList<FlatCertificate>();
        for (FlatCertificate cc : this.certificateChoices) {
            if (!sid.matches(cc)) continue;
            result.add(cc);
        }
        return result;
    }

    public Certificate getIssuer(FlatCertificate searchCertificate) {
        if (searchCertificate == null) {
            return null;
        }
        if (this.certificateChoices == null || this.certificateChoices.isEmpty()) {
            return null;
        }
        FlatCertificate entryFlatCertificate = searchCertificate;
        if (Certificate.class.isInstance(entryFlatCertificate)) {
            Certificate entryCertificate = (Certificate)Certificate.class.cast(entryFlatCertificate);
            Extensions entryExtensions = entryCertificate.getExtensions();
            if (entryExtensions == null) {
                return null;
            }
            AuthorityKeyIdentifierExtension entryAuthorityKeyIdentifier = entryExtensions.get(AuthorityKeyIdentifierExtension.class, "2.5.29.35");
            if (entryAuthorityKeyIdentifier != null) {
                GeneralNames authorityCertIssuer = entryAuthorityKeyIdentifier.getAuthorityCertIssuer();
                CertificateSerialNumber authorityCertSerialNumber = entryAuthorityKeyIdentifier.getAuthorityCertSerialNumber();
                byte[] entryAuthorityKeyIdentifierValue = null;
                if (entryAuthorityKeyIdentifier.getKeyIdentifier() != null) {
                    entryAuthorityKeyIdentifierValue = entryAuthorityKeyIdentifier.getKeyIdentifier().getValueAsByteArray();
                }
                for (FlatCertificate storeFlatCerticate : this.certificateChoices) {
                    SubjectKeyIdentifierExtension storeSubjectKeyIdentifier;
                    Extensions storeExtensions;
                    Certificate storeCertificate;
                    if (!Certificate.class.isInstance(storeFlatCerticate) || searchCertificate == (storeCertificate = (Certificate)Certificate.class.cast(storeFlatCerticate)) || Arrays.equals(searchCertificate.getSignature().getValueAsByteArray(), storeCertificate.getSignature().getValueAsByteArray()) || Arrays.equals(searchCertificate.getEncoded(), storeCertificate.getEncoded())) continue;
                    if (authorityCertIssuer != null && authorityCertSerialNumber != null && entryCertificate.getSerialNumber().getValue().equals(storeCertificate.getSerialNumber().getValue()) && authorityCertIssuer.getName().equals(storeCertificate.getSubject())) {
                        return storeCertificate;
                    }
                    if (entryAuthorityKeyIdentifierValue == null || (storeExtensions = storeCertificate.getExtensions()) == null || (storeSubjectKeyIdentifier = storeExtensions.get(SubjectKeyIdentifierExtension.class, "2.5.29.14")) == null || !Arrays.equals(entryAuthorityKeyIdentifierValue, storeSubjectKeyIdentifier.getKeyIdentifier().getValueAsByteArray())) continue;
                    return storeCertificate;
                }
            }
        }
        return null;
    }

    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.certificateChoices.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<FlatCertificate> iter = this.certificateChoices.iterator();
            while (iter.hasNext()) {
                FlatCertificate cc = iter.next();
                cc.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }
}

