/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.cms;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.SEQUENCE;
import de.bos_bremen.ci.asn1.util.OctetStringSequence;
import java.util.List;

public class AtsHashIndex
extends ANY {
    private static final String OID_SHA_256 = AlgorithmService.getDigestForName((String)"SHA256").getOID();
    private int version;
    private AlgorithmIdentifier hashAlgorithm;
    private List<OCTETSTRING> certificatesHashIndex;
    private List<OCTETSTRING> crlsHashIndex;
    private List<OCTETSTRING> unsignedAttributesHashIndex;

    public AtsHashIndex(Run _run, int version) throws ParseException {
        super(_run, false);
        this.version = version;
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos() + ", found: 0x" + Hex.hexify(tag), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        OctetStringSequence data = null;
        if (version == 1) {
            SEQUENCE seq = new SEQUENCE(_run);
            byte[] binarySequence = seq.getEncoded();
            Run certificatesHashRun = _run;
            try {
                Run r = Run.create(new BSource(binarySequence));
                this.hashAlgorithm = new AlgorithmIdentifier(r);
            }
            catch (ParseException e) {
                this.hashAlgorithm = AlgorithmIdentifier.valueOf(OID_SHA_256);
                certificatesHashRun = Run.create(new BSource(binarySequence));
            }
            data = new OctetStringSequence(certificatesHashRun);
            this.certificatesHashIndex = data.getData();
        } else {
            this.hashAlgorithm = new AlgorithmIdentifier(_run);
            data = new OctetStringSequence(_run);
            this.certificatesHashIndex = data.getData();
        }
        data = new OctetStringSequence(_run);
        this.crlsHashIndex = data.getData();
        data = new OctetStringSequence(_run);
        this.unsignedAttributesHashIndex = data.getData();
    }

    public int getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public List<OCTETSTRING> getCertificatesHashIndex() {
        return this.certificatesHashIndex;
    }

    public List<OCTETSTRING> getCrlsHashIndex() {
        return this.crlsHashIndex;
    }

    public List<OCTETSTRING> getUnsignedAttributesHashIndex() {
        return this.unsignedAttributesHashIndex;
    }
}

