/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.AbstractString;
import de.bos_bremen.ci.asn1.ParseException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class UTF8String
extends AbstractString {
    public UTF8String(Run _run) throws ParseException {
        super(_run, (byte)12);
    }

    public static UTF8String valueOf(String _value) {
        CharBuffer cb = CharBuffer.wrap(_value);
        ByteBuffer bb = Charset.forName("UTF-8").encode(cb);
        int headerPos = 0;
        int len = bb.limit();
        byte[] header = new byte[6];
        header[headerPos++] = 12;
        if (len <= 127) {
            header[headerPos++] = (byte)len;
        } else if (len < 256) {
            header[headerPos++] = -127;
            header[headerPos++] = (byte)len;
        } else if (len < 65536) {
            header[headerPos++] = -126;
            header[headerPos++] = (byte)(len >>> 8);
            header[headerPos++] = (byte)len;
        } else if (len < 0x1000000) {
            header[headerPos++] = -125;
            header[headerPos++] = (byte)(len >>> 16);
            header[headerPos++] = (byte)(len >>> 8);
            header[headerPos++] = (byte)len;
        } else {
            header[headerPos++] = -124;
            header[headerPos++] = (byte)(len >>> 24);
            header[headerPos++] = (byte)(len >>> 16);
            header[headerPos++] = (byte)(len >>> 8);
            header[headerPos++] = (byte)len;
        }
        byte[] asn1UTF8String = new byte[len + headerPos];
        System.arraycopy(header, 0, asn1UTF8String, 0, headerPos);
        System.arraycopy(bb.array(), 0, asn1UTF8String, headerPos, len);
        try {
            return new UTF8String(Run.create(new BSource(asn1UTF8String)));
        }
        catch (ParseException ex) {
            return null;
        }
    }
}

