/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.Time;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UTCTime
extends ANY
implements Time {
    private static final String DATE_FORMAT_LONG_YEAR = "yyyyMMddHHmmssZ";

    public UTCTime(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 23 && !ASN1.Factory.isTagged(tag)) {
            throw new ParseException(this, ASN1.Factory.toString((byte)23) + " expected at index " + _run.pos(), _run.pos());
        }
        int len = _run.readLength();
        _run.skip(len);
        this.setEnd(_run.pos());
    }

    public String getValue() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        return source.asUFT8String(run.pos(), len);
    }

    @Override
    public Date getDate() {
        try {
            String adjustedDateString = this.getAdjustedDateString();
            SimpleDateFormat longYearDateFormat = new SimpleDateFormat(DATE_FORMAT_LONG_YEAR);
            return longYearDateFormat.parse(adjustedDateString);
        }
        catch (java.text.ParseException parseException) {
            return null;
        }
    }

    public String getAdjustedDateString() {
        String dateString = this.getDateString();
        if (dateString.charAt(0) < '5') {
            return "20" + dateString;
        }
        return "19" + dateString;
    }

    public String getDateString() {
        String value = this.getValue();
        if (value.indexOf(45) < 0 && value.indexOf(43) < 0) {
            if (value.length() == 11) {
                return value.substring(0, 10) + "00GMT+00:00";
            }
            return value.substring(0, 12) + "GMT+00:00";
        }
        int index = value.indexOf(45);
        if (index < 0) {
            index = value.indexOf(43);
        }
        String d = value;
        if (index == value.length() - 3) {
            d = d + "00";
        }
        if (index == 10) {
            return d.substring(0, 10) + "00GMT" + d.substring(10, 13) + ":" + d.substring(13, 15);
        }
        return d.substring(0, 12) + "GMT" + d.substring(12, 15) + ":" + d.substring(15, 17);
    }

    @Override
    public String toString() {
        try {
            return "UTCTime[" + new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(this.getDate()) + "]";
        }
        catch (Exception ex) {
            return "UTCTime[" + ex.getLocalizedMessage() + "]";
        }
    }
}

