/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.GeneralizedTime;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UTCTime;
import java.util.Date;

public interface Time {
    public static final String DATE_FORMAT = "dd.MM.yyyy HH:mm:ss";

    public Date getDate();

    public byte[] asByteArray();

    public String getValueAsString();

    public static final class Factory {
        public static final Time generate(Run _run) throws ParseException {
            byte tag = _run.get();
            switch (tag) {
                case 23: {
                    return new UTCTime(_run);
                }
                case 24: {
                    return new GeneralizedTime(_run);
                }
            }
            ANY any = new ANY(_run, false);
            throw new ParseException(any, "no representation for choice \"" + Hex.hexify(tag) + "\" at index " + _run.pos(), _run.pos());
        }
    }
}

