/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.AbstractString;
import de.bos_bremen.ci.asn1.ParseException;
import java.nio.CharBuffer;

public class TeletextString
extends AbstractString {
    public TeletextString(Run _run) throws ParseException {
        super(_run, (byte)20);
    }

    @Override
    public String getValue() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        CharBuffer cb = TeletextString.replaceT61CharBuffer(source.toCharBuffer("ISO-8859-1", run.pos(), len));
        return cb.toString();
    }

    public static CharBuffer replaceT61CharBuffer(CharBuffer cb) {
        if (cb == null) {
            return null;
        }
        char[] chars = cb.array();
        int count = chars.length;
        --count;
        int i = 0;
        int j = 0;
        while (i < count) {
            block0 : switch (chars[i]) {
                case '\u00c8': {
                    switch (chars[++i]) {
                        case 'a': {
                            chars[j] = 228;
                            break block0;
                        }
                        case 'o': {
                            chars[j] = 246;
                            break block0;
                        }
                        case 'u': {
                            chars[j] = 252;
                            break block0;
                        }
                        case 'A': {
                            chars[j] = 196;
                            break block0;
                        }
                        case 'O': {
                            chars[j] = 214;
                            break block0;
                        }
                        case 'U': {
                            chars[j] = 220;
                            break block0;
                        }
                    }
                    chars[j] = chars[--i];
                    break;
                }
                case '\u00c2': {
                    if (chars[i + 1] != 'e') break;
                    ++i;
                    chars[j] = 233;
                    break;
                }
                case '\u00c1': {
                    if (chars[i + 1] != 'e') break;
                    ++i;
                    chars[j] = 232;
                    break;
                }
                case '\u00fb': {
                    chars[j] = 223;
                    break;
                }
                default: {
                    if (j == i) break;
                    chars[j] = chars[i];
                }
            }
            ++i;
            ++j;
        }
        if (j != i && j < chars.length && i < chars.length) {
            chars[j] = chars[i];
        }
        return CharBuffer.wrap(chars, 0, j + 1);
    }
}

