/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int errorOffset;

    public ParseException(ANY _any, String s, int _errorOffset) {
        super(ParseException.prepareMessage(_any.getSource(), _any.getOffset(), _any.getLength(), s, _errorOffset));
        this.errorOffset = _errorOffset;
    }

    public ParseException(CharSequence chars, String s, int _errorOffset) {
        super(ParseException.prepareMessage(chars, s, _errorOffset));
        this.errorOffset = _errorOffset;
    }

    public ParseException(String message) {
        super(message);
    }

    public int getErrorOffset() {
        return this.errorOffset;
    }

    private static String prepareMessage(Source _source, int _off, int _len, String s, int errorOffset2) {
        if (_source == null) {
            return s;
        }
        StringBuilder result = new StringBuilder();
        Throwable t = new Throwable();
        StackTraceElement[] stackTrace = t.getStackTrace();
        StackTraceElement e = null;
        for (StackTraceElement ste : stackTrace) {
            if (ParseException.class.getName().equals(ste.getClassName())) continue;
            e = ste;
            break;
        }
        if (e != null) {
            result.append(" (" + e.getClassName() + '$' + e.getMethodName() + '(' + e.getFileName() + ':' + e.getLineNumber() + ')' + ')');
        }
        result.append('\n');
        result.append(s);
        result.append('\n');
        result.append('\n');
        int offset = errorOffset2 * 3;
        for (int i = 0; i < offset; ++i) {
            result.append(' ');
        }
        result.append('^');
        result.append('\n');
        return result.toString();
    }

    private static String prepareMessage(CharSequence bytes, String s, int errorOffset2) {
        if (bytes == null) {
            return s;
        }
        StringBuilder result = new StringBuilder();
        result.append('\n');
        result.append(s);
        result.append('\n');
        result.append(bytes);
        result.append('\n');
        int offset = errorOffset2;
        for (int i = 0; i < offset; ++i) {
            result.append(' ');
        }
        result.append('^');
        result.append('\n');
        return result.toString();
    }
}

