/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.StreamUtil;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class OCTETSTRINGStream
extends InputStream {
    private InputStream content;
    private List<OCTETSTRING> construct;
    private int nextConstruct = 0;
    private boolean contentConsumed = false;
    private InputStream delegate;

    public OCTETSTRINGStream(InputStream content, List<OCTETSTRING> construct) {
        this.content = content;
        this.construct = construct;
    }

    @Override
    public int read() throws IOException {
        if (this.delegate == null) {
            this.delegate = this.getNextDelegate();
        }
        int result = -1;
        while (result < 0 && this.delegate != null) {
            result = this.delegate.read();
            if (result >= 0) continue;
            StreamUtil.close(this.delegate);
            this.delegate = this.getNextDelegate();
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.delegate == null) {
            this.delegate = this.getNextDelegate();
            if (this.delegate == null) {
                return -1;
            }
        }
        int offset = off;
        int toRead = len;
        int read = 0;
        while (toRead > 0 && this.delegate != null) {
            int result = this.delegate.read(b, offset, toRead);
            if (result <= 0) {
                StreamUtil.close(this.delegate);
                this.delegate = this.getNextDelegate();
                continue;
            }
            toRead -= result;
            offset += result;
            read += result;
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        StreamUtil.close(this.content);
        StreamUtil.close(this.delegate);
        super.close();
    }

    private InputStream getNextDelegate() throws IOException {
        InputStream stream = this.getNextDelegateFromConstruct();
        if (stream != null) {
            return stream;
        }
        if (this.contentConsumed) {
            return null;
        }
        this.contentConsumed = true;
        return this.content;
    }

    private InputStream getNextDelegateFromConstruct() throws IOException {
        OCTETSTRING octetstring;
        if (this.construct == null) {
            return null;
        }
        if (this.nextConstruct < this.construct.size() && (octetstring = this.construct.get(this.nextConstruct++)) != null) {
            return octetstring.getContentStream();
        }
        return null;
    }
}

