/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.LengthOutputStream;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.OCTETSTRINGStream;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCTETSTRING
extends ANY
implements Dumpable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OCTETSTRING.class);
    private List<OCTETSTRING> construct;

    public OCTETSTRING(Run _run) throws ParseException {
        this(_run, false);
    }

    public OCTETSTRING(Run _run, boolean _implicit) throws ParseException {
        super(_run, _implicit);
        boolean constructed;
        boolean indef;
        byte tag = _run.next();
        if (!_implicit && (tag & 4) != 4) {
            throw new ParseException(this, ASN1.Factory.toString((byte)4) + " expected at index " + _run.pos(), _run.pos());
        }
        int len = _run.readLength();
        boolean bl = indef = len == -1;
        if (!indef) {
            this.setEnd(_run.pos() + len);
        }
        boolean bl2 = constructed = (tag & 0x20) == 32;
        if (constructed) {
            this.construct = new ArrayList<OCTETSTRING>();
            while (indef || _run.pos() < this.getLength()) {
                byte b;
                if (indef && (b = _run.get()) == 0) {
                    _run.next();
                    _run.next();
                    this.setEnd(_run.pos());
                    break;
                }
                OCTETSTRING s = new OCTETSTRING(_run);
                this.construct.add(s);
            }
            return;
        }
        _run.skip(len);
    }

    @Override
    public String getValueAsString() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        return source.asHexedString(run.pos(), len);
    }

    @Override
    public String toString() {
        return "OCT(" + this.getLength() + ")[\"" + this.getValueAsString() + "\"]";
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        w.write(this.toString());
    }

    public byte[] getOctets() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        if (len == -1) {
            return new byte[0];
        }
        return run.next(len);
    }

    public void writeOctets(OutputStream os) throws IOException {
        if (this.construct != null) {
            for (OCTETSTRING oct : this.construct) {
                oct.writeOctets(os);
            }
        }
        this.getSource().write(os, this.getOffset(), this.getLength());
    }

    public void writeOctets(Signature _sig) throws IOException, SignatureException {
        if (this.construct != null) {
            for (OCTETSTRING oct : this.construct) {
                oct.writeOctets(_sig);
            }
        }
        this.getSource().write(_sig, this.getOffset(), this.getLength());
    }

    public void writeContent(OutputStream os) throws IOException {
        if (this.construct != null) {
            for (OCTETSTRING oct : this.construct) {
                oct.writeContent(os);
            }
            return;
        }
        byte[] octets = this.getOctets();
        os.write(octets);
    }

    public InputStream getContentStream() throws IOException {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        if (len == -1) {
            return new OCTETSTRINGStream(null, this.construct);
        }
        return new OCTETSTRINGStream(run.stream(len), this.construct);
    }

    public void writeContent(Signature _sig) throws IOException, SignatureException {
        if (this.construct != null) {
            for (OCTETSTRING oct : this.construct) {
                oct.writeContent(_sig);
            }
            return;
        }
        byte[] octets = this.getOctets();
        _sig.update(octets);
    }

    public byte[] getFingerPrint(String alg, String _provider) {
        try {
            MessageDigest md = _provider == null ? MessageDigest.getInstance(alg) : MessageDigest.getInstance(alg, _provider);
            DigestOutputStream out = new DigestOutputStream(new LengthOutputStream(), md);
            this.writeContent(out);
            ((OutputStream)out).close();
            return md.digest();
        }
        catch (Exception ex) {
            LOGGER.error("Exception occurred while attempting to get fingerprint.", (Throwable)ex);
            return null;
        }
    }

    public static OCTETSTRING from(byte[] hash) throws ParseException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(4);
            INTEGER.writeLength(os, hash.length);
            os.write(hash);
            return new OCTETSTRING(Run.create(new BSource(os.toByteArray())));
        }
        catch (IOException e) {
            LOGGER.error("Error occurred while parsing given hash to OCTETSTRING.", (Throwable)e);
            return null;
        }
    }
}

