/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class OBJECTIDENTIFIER
extends ANY {
    public OBJECTIDENTIFIER(String _oid) throws ParseException {
        this(Run.create(new BSource(OBJECTIDENTIFIER.toByteArray(_oid))));
    }

    public OBJECTIDENTIFIER(Run _run) throws ParseException {
        this(_run, false);
    }

    public OBJECTIDENTIFIER(Run run, boolean implicit) throws ParseException {
        super(run, implicit);
        byte tag = run.next();
        if (!implicit && tag != 6) {
            throw new ParseException(this, ASN1.Factory.toString((byte)6) + " expected at index " + run.pos(), run.pos());
        }
        run.skip(run.readLength());
        this.setEnd(run.pos());
    }

    public String getOID() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        return OBJECTIDENTIFIER.toString(run, len);
    }

    @Override
    public int hashCode() {
        return this.getOID().hashCode();
    }

    @Override
    public boolean equals(Object _o) {
        if (_o == this) {
            return true;
        }
        if (_o == null || !(_o instanceof OBJECTIDENTIFIER)) {
            return false;
        }
        return this.getOID().equals(((OBJECTIDENTIFIER)_o).getOID());
    }

    @Override
    public String toString() {
        return this.getOID();
    }

    public static OBJECTIDENTIFIER valueOf(String _oid) {
        try {
            byte[] tlv = OBJECTIDENTIFIER.createTLVStructureFor(_oid);
            OBJECTIDENTIFIER result = new OBJECTIDENTIFIER(Run.create(new BSource(tlv), 0));
            return result;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    protected static byte[] createTLVStructureFor(String _oid) {
        byte[] oid = OBJECTIDENTIFIER.toByteArray(_oid);
        byte[] tlv = new byte[oid.length + 2];
        tlv[0] = 6;
        tlv[1] = (byte)oid.length;
        System.arraycopy(oid, 0, tlv, 2, oid.length);
        return tlv;
    }

    private static String toString(Run run, int len) {
        StringBuilder objId = new StringBuilder();
        long value = 0L;
        boolean first = true;
        int end = run.pos() + len;
        while (run.pos() < end) {
            byte b = run.next();
            value = value * 128L + (long)(b & 0x7F);
            if ((b & 0x80) != 0) continue;
            if (first) {
                switch ((int)value / 40) {
                    case 0: {
                        objId.append('0');
                        break;
                    }
                    case 1: {
                        objId.append('1');
                        value -= 40L;
                        break;
                    }
                    default: {
                        objId.append('2');
                        value -= 80L;
                    }
                }
                first = false;
            }
            objId.append('.');
            objId.append(Long.toString(value));
            value = 0L;
        }
        return objId.toString();
    }

    private static void writeField(OutputStream out, long fieldValue) {
        try {
            if (fieldValue >= 128L) {
                if (fieldValue >= 16384L) {
                    if (fieldValue >= 0x200000L) {
                        if (fieldValue >= 0x10000000L) {
                            if (fieldValue >= 0x800000000L) {
                                if (fieldValue >= 0x40000000000L) {
                                    if (fieldValue >= 0x2000000000000L) {
                                        if (fieldValue >= 0x100000000000000L) {
                                            out.write((int)(fieldValue >> 56) | 0x80);
                                        }
                                        out.write((int)(fieldValue >> 49) | 0x80);
                                    }
                                    out.write((int)(fieldValue >> 42) | 0x80);
                                }
                                out.write((int)(fieldValue >> 35) | 0x80);
                            }
                            out.write((int)(fieldValue >> 28) | 0x80);
                        }
                        out.write((int)(fieldValue >> 21) | 0x80);
                    }
                    out.write((int)(fieldValue >> 14) | 0x80);
                }
                out.write((int)(fieldValue >> 7) | 0x80);
            }
            out.write((int)fieldValue & 0x7F);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeField(OutputStream out, BigInteger fieldValue) {
        try {
            int byteCount = (fieldValue.bitLength() + 6) / 7;
            if (byteCount == 0) {
                out.write(0);
                return;
            }
            BigInteger tmpValue = fieldValue;
            byte[] tmp = new byte[byteCount];
            for (int i = byteCount - 1; i >= 0; --i) {
                tmp[i] = (byte)(tmpValue.intValue() & 0x7F | 0x80);
                tmpValue = tmpValue.shiftRight(7);
            }
            int n = byteCount - 1;
            tmp[n] = (byte)(tmp[n] & 0x7F);
            out.write(tmp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(String _oid) {
        OIDTokenizer tok = new OIDTokenizer(_oid);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        OBJECTIDENTIFIER.writeField((OutputStream)bOut, (long)Integer.parseInt(tok.nextToken()) * 40L + (long)Integer.parseInt(tok.nextToken()));
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.length() < 18) {
                OBJECTIDENTIFIER.writeField((OutputStream)bOut, Long.parseLong(token));
                continue;
            }
            OBJECTIDENTIFIER.writeField((OutputStream)bOut, new BigInteger(token));
        }
        byte[] bytes = bOut.toByteArray();
        return bytes;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        Run run = Run.create(this.getSource(), this.getOffset());
        os.write(run.next(this.getLength()));
    }

    public static class OIDTokenizer {
        private String oid;
        private int index;

        public OIDTokenizer(String _oid) {
            this.oid = _oid;
            this.index = 0;
        }

        public boolean hasMoreTokens() {
            return this.index != -1;
        }

        public String nextToken() {
            if (this.index == -1) {
                return null;
            }
            int end = this.oid.indexOf(46, this.index);
            if (end == -1) {
                String token = this.oid.substring(this.index);
                this.index = -1;
                return token;
            }
            String token = this.oid.substring(this.index, end);
            this.index = end + 1;
            return token;
        }
    }
}

