/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class INTEGER
extends ANY {
    public INTEGER(int i) throws ParseException {
        this(INTEGER.build(i), false);
    }

    public INTEGER(Run _run) throws ParseException {
        this(_run, false);
    }

    public INTEGER(Run _run, boolean _implicit) throws ParseException {
        super(_run, _implicit);
        byte tag = _run.next();
        if (!_implicit && tag != 2) {
            throw new ParseException(this, ASN1.Factory.toString((byte)2) + " expected at index " + _run.pos(), _run.pos());
        }
        int len = _run.readLength();
        _run.skip(len);
        this.setEnd(_run.pos());
    }

    public BigInteger getValue() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        if (len == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(run.next(len));
    }

    @Override
    public String getValueAsString() {
        return this.getValue().toString();
    }

    @Override
    public String toString() {
        return "INT[" + this.getValueAsString() + "]";
    }

    public static void writeLength(OutputStream os, int length) throws IOException {
        if (length < 0) {
            throw new IOException("negative length : " + length);
        }
        if (length <= 255) {
            if (length == 129) {
                os.write(-127);
            }
            os.write((byte)length);
        } else {
            int bla;
            int i;
            os.write(0x80 | length / 256);
            int l = length;
            for (i = 24; i >= 0 && (bla = l >> i) == 0; i -= 8) {
            }
            while (i >= 0) {
                bla = l >> i;
                os.write(bla & 0xFF);
                i -= 8;
            }
        }
    }

    public static void writeLength(StringBuilder os, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("negative length : " + length);
        }
        if (length <= 255) {
            if (length == 129) {
                os.append(-127);
            }
            os.append((byte)length);
        } else {
            int bla;
            int i;
            os.append(0x80 | length / 256);
            int l = length;
            for (i = 24; i >= 0 && (bla = l >> i) == 0; i -= 8) {
            }
            while (i >= 0) {
                bla = l >> i;
                os.append(bla & 0xFF);
                i -= 8;
            }
        }
    }

    public static int lengthLength(int length) {
        if (length < 0) {
            return -1;
        }
        if (length <= 255) {
            return 1;
        }
        int result = 0;
        for (int i = length; i > 0; i >>= 8) {
            ++result;
        }
        return result;
    }

    private static Run build(int _i) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream(4);
            os.write(2);
            INTEGER.writeLength(os, _i);
            for (int mask = -16777216; mask != 0; mask >>>= 8) {
                os.write(_i & mask);
            }
            return Run.create(new BSource(os.toByteArray()), 0);
        }
        catch (IOException e) {
            return null;
        }
    }
}

