/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.ISO8601Format;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.Time;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class GeneralizedTime
extends ANY
implements Time {
    private Calendar time;

    public GeneralizedTime(Run _run) throws ParseException {
        this(_run, false);
    }

    public GeneralizedTime(Run _run, boolean _implicit) throws ParseException {
        super(_run, _implicit);
        byte tag = _run.next();
        if (!_implicit && tag != 24) {
            throw new ParseException(this, ASN1.Factory.toString((byte)24) + " expected at index " + _run.pos(), _run.pos());
        }
        int length = _run.readLength();
        this.setEnd(_run.pos() + length);
        ByteBuffer bb = ByteBuffer.wrap(_run.next(length));
        CharBuffer cb = Charset.forName("UTF-8").decode(bb);
        this.time = Calendar.getInstance();
        try {
            ISO8601Format iso8601 = new ISO8601Format();
            this.time.setTime(iso8601.parse(cb.toString()));
        }
        catch (java.text.ParseException ex) {
            ParseException e = new ParseException(cb.toString(), ex.getMessage(), ex.getErrorOffset());
            throw e;
        }
        catch (NumberFormatException ex) {
            ParseException e = new ParseException(cb.toString(), ex.getMessage(), 0);
            throw e;
        }
    }

    @Override
    public String toString() {
        try {
            return "GTime[" + new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(this.getDate()) + "]";
        }
        catch (Exception ex) {
            return "GTime[" + ex.getLocalizedMessage() + "]";
        }
    }

    @Override
    public Date getDate() {
        return this.time.getTime();
    }
}

