/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.AbstractString;
import de.bos_bremen.ci.asn1.ParseException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class BMPString
extends AbstractString {
    public BMPString(Run _run) throws ParseException {
        super(_run, (byte)30);
    }

    @Override
    public String getValue() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        byte[] buf = new byte[len / 2];
        while (run.get() == 0) {
            run.next();
        }
        for (int k = 0; k < buf.length; ++k) {
            buf[k] = run.next();
            run.skip(1);
        }
        ByteBuffer bb = ByteBuffer.wrap(buf);
        CharBuffer cb = Charset.forName("ISO-8859-1").decode(bb);
        return cb.toString();
    }
}

