/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import java.math.BigInteger;

public class BITSTRING
extends ANY {
    private static final int PAD_BYTE = 1;

    public BITSTRING(Run _run) throws ParseException {
        this(_run, false);
    }

    public BITSTRING(Run _run, boolean _implicit) throws ParseException {
        super(_run, _implicit);
        byte tag = _run.next();
        if (!_implicit && tag != 3) {
            throw new ParseException(this, ASN1.Factory.toString((byte)3) + " expected at index " + _run.pos(), _run.pos());
        }
        int len = _run.readLength();
        _run.skip(len);
        this.setEnd(_run.pos());
    }

    public boolean is(int _bitIndex) {
        if (_bitIndex < 0) {
            return false;
        }
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        run.readLength();
        run.skip(1);
        int i = _bitIndex / 8;
        if (run.pos() + i >= this.getEnd()) {
            return false;
        }
        run.skip(i);
        int value = run.get() & 0xFF;
        int mask = 1 << 7 - _bitIndex % 8;
        boolean result = (value & mask) != 0;
        return result;
    }

    public int getPadBits() {
        Run run = Run.create(this.getSource(), this.getOffset() + 1);
        run.readLength();
        byte b = run.get();
        int padBitCount = 0xF & b;
        return padBitCount;
    }

    public int getBitLength() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int lengthInBytes = run.readLength();
        run.skip(1);
        int lengthInBits = --lengthInBytes * 8;
        return lengthInBits -= this.getPadBits();
    }

    public boolean[] getValue() {
        return this.getValueAsBooleanArray();
    }

    public boolean[] getValueAsBooleanArray() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        run.readLength();
        run.skip(1);
        int bitLength = this.getBitLength();
        boolean[] result = new boolean[bitLength];
        byte b = 0;
        for (int k = 0; k < bitLength; ++k) {
            if (k % 8 == 0) {
                b = run.next();
            }
            result[k] = (b & 0x80) == 128;
            b = (byte)(b << 1);
        }
        return result;
    }

    @Override
    public byte[] getValueAsByteArray() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        run.skip(1);
        byte[] byteArray = run.next(--len);
        int padBitCount = this.getPadBits();
        if (padBitCount > 0) {
            BigInteger bigInt = new BigInteger(1, byteArray);
            bigInt = bigInt.shiftRight(padBitCount);
            byteArray = bigInt.toByteArray();
        }
        return byteArray;
    }

    public String getShortKeyUsage() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        run.skip(1);
        int k = 0;
        char[] result = new char[--len * 8];
        while (len > 0) {
            byte b = run.next();
            int j = 0;
            while (j < 8) {
                result[k * 8 + j++] = (b & 0x80) == 128 ? 49 : 48;
                b = (byte)(b << 1);
            }
            --len;
            ++k;
        }
        return new String(result);
    }

    @Override
    public String toString() {
        return "BIT(" + this.getLength() + "," + this.getPadBits() + ")[\"" + this.getValueAsString() + "\"]";
    }
}

