/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.NULL;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DSAParameters;
import de.bos_bremen.ci.asn1.x509.RSASSAPSSParameters;
import de.bos_bremen.ci.asn1.x509.ec.ECPKParameters;

public interface AlgorithmIdentifierParameter {
    public static final String ID_DSA_PREFIX = "1.2.840.10040.4";
    public static final String ID_EC_PREFIX = "1.2.840.10045";
    public static final String ID_EC_BSI_PREFIX = "0.4.0.127.0.7.1.1.4.1";
    public static final String ID_RSASSA_PSS_PREFIX = "1.2.840.113549.1.1.10";
    public static final String ID_RSASSA_PSS_MGF1_PREFIX = "1.2.840.113549.1.1.8";

    public static class Factory {
        public static ANY generate(Run run, OBJECTIDENTIFIER algorithmID) throws ParseException {
            byte tag = run.get();
            if (tag == 5) {
                return new NULL(run);
            }
            if (algorithmID.toString().startsWith(AlgorithmIdentifierParameter.ID_DSA_PREFIX)) {
                return new DSAParameters(run);
            }
            if (algorithmID.toString().startsWith(AlgorithmIdentifierParameter.ID_EC_PREFIX) || algorithmID.toString().startsWith(AlgorithmIdentifierParameter.ID_EC_BSI_PREFIX)) {
                return ECPKParameters.Factory.generate(run);
            }
            if (algorithmID.toString().startsWith(AlgorithmIdentifierParameter.ID_RSASSA_PSS_PREFIX)) {
                return new RSASSAPSSParameters(run);
            }
            if (algorithmID.toString().startsWith(AlgorithmIdentifierParameter.ID_RSASSA_PSS_MGF1_PREFIX)) {
                return new AlgorithmIdentifier(run);
            }
            ANY param = new ANY(run, false);
            run.next();
            run.skip(run.readLength());
            param.setEnd(run.pos());
            return param;
        }
    }
}

