/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.PaddingAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.AbstractAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.SignatureAlgorithmBase;
import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifierParameter;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.NULL;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DSAParameters;
import de.bos_bremen.ci.asn1.x509.RSASSAPSSParameters;
import de.bos_bremen.ci.asn1.x509.ec.ECPKParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class AlgorithmIdentifier
extends ANY
implements Dumpable,
Flattable {
    private final OBJECTIDENTIFIER algorithmID;
    private final ANY parameters;
    private Algorithm algorithm;

    public AlgorithmIdentifier(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.algorithmID = new OBJECTIDENTIFIER(_run);
        if (_run.pos() >= end) {
            this.parameters = null;
            this.algorithm = this.initAlgorithm();
            return;
        }
        this.parameters = AlgorithmIdentifierParameter.Factory.generate(_run, this.algorithmID);
        if (RSASSAPSSParameters.class.isInstance(this.parameters)) {
            RSASSAPSSParameters rsaParams = (RSASSAPSSParameters)RSASSAPSSParameters.class.cast(this.parameters);
            PaddingAlgorithm padding = AlgorithmService.getPaddingForOID((String)"1.2.840.113549.1.1.10");
            this.algorithm = AlgorithmService.getSignature((SignatureAlgorithmBase)SignatureAlgorithmBase.RSA, (DigestAlgorithm)rsaParams.getDigestAlgorithm(), (PaddingAlgorithm)padding, null);
        } else if (!(RSASSAPSSParameters.OID_MGF1.equals(this.algorithmID) || DSAParameters.class.isInstance(this.parameters) || ECPKParameters.class.isInstance(this.parameters))) {
            this.algorithm = this.initAlgorithm();
        }
    }

    private Algorithm initAlgorithm() {
        ArrayList listAlgorithms = new ArrayList(AlgorithmService.getForOID((String)this.algorithmID.getOID()));
        if (listAlgorithms.isEmpty()) {
            return null;
        }
        ArrayList<Algorithm> listAliasAlgorithms = new ArrayList<Algorithm>();
        for (Algorithm a : listAlgorithms) {
            if (AbstractAlgorithm.class.isInstance(a)) continue;
            listAliasAlgorithms.add(a);
        }
        listAlgorithms.removeAll(listAliasAlgorithms);
        if (listAlgorithms.size() == 1) {
            return (Algorithm)listAlgorithms.get(0);
        }
        return null;
    }

    public static AlgorithmIdentifier valueOf(String oid) throws ParseException {
        return new AlgorithmIdentifier(OBJECTIDENTIFIER.valueOf(oid), null);
    }

    public static AlgorithmIdentifier valueOf(Algorithm algorithm) throws ParseException {
        return new AlgorithmIdentifier(algorithm, null);
    }

    public AlgorithmIdentifier(Algorithm algorithm, ANY _parameters) throws ParseException {
        this.algorithm = algorithm;
        this.algorithmID = OBJECTIDENTIFIER.valueOf(algorithm.getOID());
        this.parameters = _parameters;
    }

    public AlgorithmIdentifier(OBJECTIDENTIFIER _oid, ANY _parameters) throws ParseException {
        this(AlgorithmIdentifier.createRun(_oid, _parameters));
    }

    private static Run createRun(OBJECTIDENTIFIER _oid, ANY _parameters) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(48);
            int length = _oid.getLength();
            INTEGER.writeLength(os, length += _parameters == null ? 2 : _parameters.getLength());
            _oid.encode(os);
            if (_parameters == null) {
                os.write(5);
                os.write(0);
            } else {
                os.write(_parameters.asByteArray());
            }
            return Run.create(new BSource(os.toByteArray()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean shortForm) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        result.add(new Flattable.Pair(res.getString("general.publickey.algorithm.name"), this.getAlgorithmName()));
        if (this.parameters != null && !(this.parameters instanceof NULL)) {
            if (this.parameters instanceof Flattable) {
                result.addAll(((Flattable)((Object)this.parameters)).flatten(res, shortForm));
            } else {
                result.add(new Flattable.Pair(res.getString("general.publickey.algorithm.parameters"), this.parameters.toString()));
            }
        }
        return result;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("Name: ");
        w.write(this.getAlgorithmName());
        w.newLine();
        w.write("OID: ");
        w.write(this.algorithmID.toString());
        if (this.parameters != null) {
            w.newLine();
            if (this.parameters instanceof Dumpable) {
                ((Dumpable)((Object)this.parameters)).dump(w);
            } else {
                w.write("Parameters: ");
                w.write(this.parameters.toString());
            }
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public OBJECTIDENTIFIER getOID() {
        return this.algorithmID;
    }

    public ANY getParameters() {
        return this.parameters;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getAlgorithmName() {
        if (this.algorithm != null) {
            return this.algorithm.getName();
        }
        List algorithms = AlgorithmService.getForOID((String)this.algorithmID.getOID());
        if (algorithms.size() > 0) {
            return ((Algorithm)algorithms.get(0)).getName();
        }
        return this.algorithmID.getOID();
    }

    public String getJCAName() {
        if (this.algorithm != null) {
            return this.algorithm.getJCAName();
        }
        List algorithms = AlgorithmService.getForOID((String)this.algorithmID.getOID());
        if (algorithms.size() > 0) {
            return ((Algorithm)algorithms.get(0)).getJCAName();
        }
        return this.algorithmID.getOID();
    }

    @Override
    public String toString() {
        return this.getAlgorithmName();
    }
}

