/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.BMPString;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.GeneralString;
import de.bos_bremen.ci.asn1.GraphicString;
import de.bos_bremen.ci.asn1.IA5String;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.PrintableString;
import de.bos_bremen.ci.asn1.TeletextString;
import de.bos_bremen.ci.asn1.UTF8String;
import de.bos_bremen.ci.asn1.UniversalString;
import de.bos_bremen.ci.asn1.VideoTexString;
import de.bos_bremen.ci.asn1.VisibleString;
import java.io.IOException;

public abstract class AbstractString
extends ANY
implements CharString {
    private byte type;

    protected AbstractString(Run _run, byte type) throws ParseException {
        this(_run, false, type);
    }

    protected AbstractString(Run _run, boolean implicit, byte type) throws ParseException {
        super(_run, implicit);
        byte tag = _run.next();
        if (!implicit && tag != type) {
            throw new ParseException(this, ASN1.Factory.toString(type) + " expected at index " + _run.pos(), _run.pos());
        }
        this.type = type;
        _run.skip(_run.readLength());
        this.setEnd(_run.pos());
    }

    @Override
    public String getValue() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        return source.asUFT8String(run.pos(), len);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        w.write(this.toString());
    }

    @Override
    public String toString() {
        return ASN1.Factory.toString(this.type) + "[" + this.getValue() + "]";
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    public static final AbstractString generate(Run _run) throws ParseException {
        byte tag = _run.get();
        if (tag == 10) {
            _run.next();
            tag = _run.get();
        }
        switch (tag) {
            case 48: 
            case 49: {
                StringBuilder result = new StringBuilder();
                _run.next();
                int adEnd = _run.readLength();
                adEnd += _run.pos();
                while (_run.pos() < adEnd) {
                    AbstractString line = AbstractString.generate(_run);
                    result.append(line.getValue());
                    if (_run.pos() >= adEnd) continue;
                    result.append('\n');
                }
                return UTF8String.valueOf(result.toString());
            }
            case 30: {
                return new BMPString(_run);
            }
            case 19: {
                return new PrintableString(_run);
            }
            case 20: {
                return new TeletextString(_run);
            }
            case 28: {
                return new UniversalString(_run);
            }
            case 26: {
                return new VisibleString(_run);
            }
            case 22: {
                return new IA5String(_run);
            }
            case 12: {
                return new UTF8String(_run);
            }
            case 21: {
                return new VideoTexString(_run);
            }
            case 25: {
                return new GraphicString(_run);
            }
            case 27: {
                return new GeneralString(_run);
            }
        }
        throw new IllegalArgumentException("no representation for choice \"" + Hex.hexify(tag) + "\" at index " + _run.pos());
    }
}

