/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AbstractString;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.BOOLEAN;
import de.bos_bremen.ci.asn1.GeneralizedTime;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.NULL;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UTCTime;

public interface ASN1 {
    public static final byte BOOLEAN = 1;
    public static final byte INTEGER = 2;
    public static final byte BITSTRING = 3;
    public static final byte OCTETSTRING = 4;
    public static final byte NULL = 5;
    public static final byte OBJECTIDENTIFIER = 6;
    public static final byte REAL = 9;
    public static final byte ENUMERATED = 10;
    public static final byte UTF8STRING = 12;
    public static final byte SEQUENCE = 48;
    public static final byte SET = 49;
    public static final byte PIN_REFERENCE = -128;
    public static final byte EXTERNAL = 8;
    public static final byte NUMERIC_STRING = 18;
    public static final byte PRINTABLE_STRING = 19;
    public static final byte T61_STRING = 20;
    public static final byte VIDEOTEX_STRING = 21;
    public static final byte IA5_STRING = 22;
    public static final byte UTC_TIME = 23;
    public static final byte GENERALIZED_TIME = 24;
    public static final byte GRAPHIC_STRING = 25;
    public static final byte VISIBLE_STRING = 26;
    public static final byte GENERAL_STRING = 27;
    public static final byte UNIVERSAL_STRING = 28;
    public static final byte BMP_STRING = 30;
    public static final byte TAGGED = -128;
    public static final byte CONSTRUCTED = 32;
    public static final byte TAGGEDCONSTRUCTED = -96;

    public static final class Factory {
        public static String toString(byte type) {
            if (Factory.isTaggedConstructed(type)) {
                if ((type & 0x20 & 0xFFFFFF80) == 0) {
                    return "TAGGEDCONSTRUCTED";
                }
                if (type == 49) {
                    return "SET";
                }
                if (type == 48) {
                    return "SEQUENCE";
                }
                if ((type & 0xFFFFFF80) == -128) {
                    return "TAGGED";
                }
                return "CONSTRUCTED";
            }
            switch (type) {
                case 1: {
                    return "BOOLEAN";
                }
                case 2: {
                    return "INTEGER";
                }
                case 3: {
                    return "BITSTRING";
                }
                case 4: {
                    return "OCTETSTRING";
                }
                case 5: {
                    return "NULL";
                }
                case 6: {
                    return "OBJECTIDENTIFIER";
                }
                case 9: {
                    return "REAL";
                }
                case 10: {
                    return "ENUMERATED";
                }
                case 12: {
                    return "UTF8STRING";
                }
                case 48: {
                    return "SEQUENCE";
                }
                case 49: {
                    return "SET";
                }
                case -128: {
                    return "PIN_REFERENCE";
                }
                case 8: {
                    return "EXTERNAL";
                }
                case 18: {
                    return "NUMERIC_STRING";
                }
                case 19: {
                    return "PRINTABLE_STRING";
                }
                case 20: {
                    return "T61_STRING";
                }
                case 21: {
                    return "VIDEOTEX_STRING";
                }
                case 22: {
                    return "IA5_STRING";
                }
                case 23: {
                    return "UTC_TIME";
                }
                case 24: {
                    return "GENERALIZED_TIME";
                }
                case 25: {
                    return "GRAPHIC_STRING";
                }
                case 26: {
                    return "VISIBLE_STRING";
                }
                case 27: {
                    return "GENERAL_STRING";
                }
                case 28: {
                    return "UNIVERSAL_STRING";
                }
                case 30: {
                    return "BMP_STRING";
                }
            }
            return "UNKNOWN TYPE (" + Hex.hexify(type) + ")";
        }

        public static ANY generate(Run _run) throws ParseException {
            byte tag = _run.get();
            switch (tag) {
                case 3: {
                    return new BITSTRING(_run);
                }
                case 1: {
                    return new BOOLEAN(_run);
                }
                case 2: {
                    return new INTEGER(_run);
                }
                case 5: {
                    return new NULL(_run);
                }
                case 6: {
                    return new OBJECTIDENTIFIER(_run);
                }
                case 4: {
                    return new OCTETSTRING(_run);
                }
                case 23: {
                    return new UTCTime(_run);
                }
                case 24: {
                    return new GeneralizedTime(_run);
                }
            }
            try {
                AbstractString result = AbstractString.generate(_run);
                return result;
            }
            catch (IllegalArgumentException result) {
                ANY result2 = new ANY(_run, false);
                _run.next();
                int len = _run.readLength();
                int end = len + _run.pos();
                result2.setEnd(end);
                _run.skip(len);
                return result2;
            }
        }

        public static boolean isTaggedConstructed(byte taggedByte) {
            return (taggedByte & 0xFFFFFFA0) == -96;
        }

        public static boolean isTaggedConstructedAs(byte taggedByte, int tagNumber) {
            return Factory.isTaggedConstructedAs(taggedByte, (byte)tagNumber);
        }

        @Deprecated
        public static boolean isTaggedConstructedAs(byte taggedByte, byte tagNumber) {
            return Factory.isTaggedConstructed(taggedByte) && Factory.getTagNumber(taggedByte) == tagNumber;
        }

        public static boolean isTagged(byte taggedByte) {
            return (taggedByte & 0xFFFFFF80) == -128;
        }

        public static boolean isTaggedAs(byte taggedByte, int tagNumber) {
            return Factory.isTaggedAs(taggedByte, (byte)tagNumber);
        }

        @Deprecated
        public static boolean isTaggedAs(byte taggedByte, byte tagNumber) {
            return Factory.isTagged(taggedByte) && Factory.getTagNumber(taggedByte) == tagNumber;
        }

        public static byte getTagNumber(byte taggedByte) {
            return (byte)(taggedByte & 0x1F);
        }
    }
}

