/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1;

import de.bos_bremen.ci.CIDump;
import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Range;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.OID;
import de.bos_bremen.ci.asn1.UnexpectedASN1ObjectException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class ANY {
    private Source source;
    private final Range range;
    protected boolean implicit;

    public static ANY createANY(Run run) {
        ANY any = new ANY(run, false);
        run.next();
        int l = run.readLength();
        any.setLength(l);
        run.skip(l);
        return any;
    }

    protected ANY() {
        this.range = new Range();
    }

    public ANY(Source _source, int _index, boolean _implicit) {
        this.implicit = _implicit;
        this.range = new Range(_index, -1);
        this.source = _source;
    }

    public ANY(Run _run, boolean _implicit) {
        this(_run.getSource(), _run.pos(), _implicit);
    }

    public final byte[] asByteArray() {
        Run run = Run.create(this.getSource(), this.range.getOff());
        return run.next(this.range.getLen());
    }

    public int hashCode() {
        byte[] fingerprint = this.getSource().getFingerprint("MD5", this.getOffset(), this.getLength());
        return new BigInteger(fingerprint).intValue();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ANY)) {
            return false;
        }
        ANY other = (ANY)o;
        if (this.getLength() != other.getLength()) {
            return false;
        }
        return ANY.equals(this.getSource(), this.getOffset(), other.getSource(), other.getOffset(), other.getLength());
    }

    private static boolean equals(Source _source, int _off1, Source _source2, int _off2, int _len) {
        Run r1 = Run.create(_source, _off1);
        Run r2 = Run.create(_source2, _off2);
        while (r1.pos() < _len) {
            if (r1.next() == r2.next()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.getSource() == null) {
            return this.getClass().getSimpleName() + "[null]";
        }
        return this.getClass().getSimpleName() + "[" + this.range.getLen() + " \"" + this.getValueAsString() + "\"]";
    }

    public Source getSource() {
        return this.source;
    }

    public String getValueAsString() {
        return this.getValueAsHexedString();
    }

    public final String getValueAsHexedString() {
        byte[] bytes = this.getValueAsByteArray();
        return Hex.hexify(bytes);
    }

    public byte[] getValueAsByteArray() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        byte[] bytes = run.next(len);
        return bytes;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public int getLength() {
        return this.range.getLen();
    }

    public int getOffset() {
        return this.range.getOff();
    }

    public int getEnd() {
        return this.range.getOff() + this.range.getLen();
    }

    public void setEnd(int _end) {
        this.range.setLen(_end - this.range.getOff());
    }

    public void setLength(int length) {
        this.range.setLen(length);
    }

    public static boolean initSequence(ANY any, Run run) throws UnexpectedASN1ObjectException {
        int end = run.pos();
        if (run.next() != 48) {
            throw new UnexpectedASN1ObjectException(any, 48, end);
        }
        int l = run.readLength();
        end = run.pos() + l;
        any.setLength(l);
        any.setEnd(end);
        if (CIDump.isDumpEnabled()) {
            System.out.println("SEQ-" + any.getClass().getSimpleName() + "-length: " + l + " (" + Hex.hexify(l) + ")");
        }
        return run.pos() >= any.getEnd();
    }

    public static boolean initSequenceOfSequence(ANY any, Run run) throws UnexpectedASN1ObjectException {
        if (ANY.initSequence(any, run)) {
            return true;
        }
        if (run.next() != 48) {
            throw new UnexpectedASN1ObjectException(any, 48, run.pos());
        }
        return run.readLength() == 0;
    }

    public byte[] getEncoded() {
        return this.getSource().getAbs(this.range.getOff(), this.range.getLen());
    }

    public byte[] getFingerprint(String _digestAlgorithm) {
        return this.getSource().getFingerprint(_digestAlgorithm, this.getOffset(), this.getLength());
    }

    public String getHexedFingerprint(String _digestAlgorithm) {
        return Hex.hexify(this.getFingerprint(_digestAlgorithm), false, false);
    }

    public String getHexedFingerprint(String _digestAlgorithm, boolean _withSpaces) {
        return Hex.hexify(this.getFingerprint(_digestAlgorithm), false, _withSpaces);
    }

    public void encode(OutputStream os) throws IOException {
        this.getSource().write(os, this.range.getOff(), this.range.getLen());
    }

    public static <A extends ANY> void writeClassName(A any, DumpWriter writer) throws IOException {
        OID oid;
        String s;
        String simpleClassName = any.getClass().getSimpleName();
        writer.write(simpleClassName);
        writer.write(32);
        writer.write(40);
        writer.write(Integer.toString(any.getOffset()));
        writer.write(41);
        if (any instanceof OID && (s = (oid = (OID)((Object)any)).getOID()) != null) {
            writer.write(32);
            writer.write(34);
            writer.write(((OID)((Object)any)).getOID());
            writer.write(34);
        }
    }
}

