/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtil {
    public static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtil.read(in, out, -1);
        return out.toByteArray();
    }

    public static byte[] read(InputStream in, int len) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtil.read(in, out, len);
        return out.toByteArray();
    }

    public static int read(InputStream in, OutputStream out) throws IOException {
        return StreamUtil.read(in, out, -1);
    }

    public static int read(InputStream in, OutputStream out, int len) throws IOException {
        int bufSize = 8192;
        byte[] buf = new byte[bufSize];
        int requestedSize = len >= 0 ? Math.min(bufSize, len) : bufSize;
        int currentRead = -1;
        int totalRead = 0;
        while ((currentRead = in.read(buf, 0, requestedSize)) != -1) {
            out.write(buf, 0, currentRead);
            if (len < totalRead) continue;
            requestedSize = Math.min(bufSize, len - (totalRead += currentRead));
            if (len != totalRead) continue;
            break;
        }
        return totalRead;
    }
}

