/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.LengthOutputStream;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.StreamUtil;
import de.bos_bremen.ci.StreamableInputData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;

public class SSource
extends Source {
    public final StreamableInputData streamableSource;

    public SSource(StreamableInputData s) {
        this.streamableSource = s;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte getAbs(int index) {
        try (InputStream is = this.streamableSource.getInputStream();){
            this.skipInputStream(is, index);
            byte by = (byte)is.read();
            return by;
        }
        catch (IOException ex) {
            throw new CannotReadSSourceException(this.streamableSource, ex);
        }
    }

    private int skipInputStream(InputStream is, int length) throws IOException {
        int skipped = 0;
        if (length > 0) {
            int bytesToSkip = length - 1;
            skipped = (int)((long)skipped + is.skip(bytesToSkip));
        }
        if (length > 0) {
            boolean isEOF;
            boolean bl = isEOF = is.read() == -1;
            if (!isEOF) {
                ++skipped;
            }
        }
        return skipped;
    }

    @Override
    public byte[] getAbs(int offset, int length) {
        byte[] buffer = new byte[length];
        this.getAbs(buffer, 0, offset, length);
        return buffer;
    }

    @Override
    public void getAbs(byte[] buffer, int bufferOffset, int sourceOffset, int length) {
        try (InputStream sourceStream = this.streamableSource.getInputStream();){
            long skipped = this.skipInputStream(sourceStream, sourceOffset);
            if (skipped != (long)sourceOffset) {
                throw new IndexOutOfBoundsException("Offset too large " + sourceOffset);
            }
            int read = sourceStream.read(buffer, bufferOffset, length);
            if (read != length) {
                throw new IndexOutOfBoundsException("Length is too long " + length);
            }
        }
        catch (IOException ex) {
            throw new CannotReadSSourceException(this.streamableSource, ex);
        }
    }

    @Override
    public InputStream contentAsInputStream(int offset, int length) {
        InputStream is = null;
        try {
            is = this.streamableSource.getInputStream();
            long skipped = this.skipInputStream(is, offset);
            if (skipped != (long)offset) {
                StreamUtil.close(is);
                throw new IndexOutOfBoundsException("Offset too large " + offset);
            }
            return new LimitInputStream(is, length);
        }
        catch (IOException e) {
            throw new CannotReadSSourceException(this.streamableSource, e);
        }
    }

    @Override
    public String asHexedString(int offset, int length) {
        byte[] bytes = this.getAbs(offset, length);
        return Hex.hexify(bytes);
    }

    @Override
    public String asUFT8String(int offset, int length) {
        return this.toCharBuffer("UTF-8", offset, length).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CharBuffer toCharBuffer(String encoding) {
        ByteBuffer bb = null;
        try (InputStream in = this.streamableSource.getInputStream();){
            bb = ByteBuffer.wrap(StreamUtil.read(in));
            if (encoding == null) {
                CharBuffer charBuffer = bb.asCharBuffer();
                return charBuffer;
            }
            CharBuffer charBuffer = Charset.forName(encoding).decode(bb);
            return charBuffer;
        }
        catch (IOException e) {
            throw new CannotReadSSourceException(this.streamableSource, e);
        }
    }

    @Override
    public CharBuffer toCharBuffer(String encoding, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(this.getAbs(offset, length));
        if (encoding == null) {
            return bb.asCharBuffer();
        }
        return Charset.forName(encoding).decode(bb);
    }

    @Override
    public void write(OutputStream os, int offset, int length) throws IOException {
        os.write(this.getAbs(offset, length));
    }

    @Override
    public void write(Signature sig, int offset, int length) throws IOException, SignatureException {
        sig.update(this.getAbs(offset, length));
    }

    @Override
    public byte[] getFingerprint(String mdType, int offset, int length) {
        try {
            MessageDigest md = MessageDigest.getInstance(mdType);
            try (InputStream is = this.streamableSource.getInputStream();
                 DigestOutputStream digestOut = new DigestOutputStream(new LengthOutputStream(), md);){
                long skipped = this.skipInputStream(is, offset);
                if (skipped != (long)offset) {
                    throw new IndexOutOfBoundsException("Offset too large " + offset);
                }
                int read = StreamUtil.read(is, digestOut, length);
                if (read != length) {
                    throw new IndexOutOfBoundsException("Length is too long " + length);
                }
                digestOut.flush();
            }
            return md.digest();
        }
        catch (IOException ex) {
            throw new CannotReadSSourceException(this.streamableSource, ex);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static class CannotReadSSourceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private CannotReadSSourceException(StreamableInputData s, IOException e) {
            super("Cannot read streamable source " + s.getName(), e);
        }
    }

    public static class LimitInputStream
    extends InputStream {
        private InputStream is;
        private int len;

        public LimitInputStream(InputStream in, int l) {
            this.is = in;
            this.len = l;
        }

        @Override
        public int read() throws IOException {
            if (this.len == 0) {
                return -1;
            }
            --this.len;
            return this.is.read();
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (this.len == 0) {
                return -1;
            }
            int l = Math.max(0, Math.min(this.len, length));
            int read = this.is.read(buffer, offset, l);
            this.len -= read;
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.len == 0) {
                return -1L;
            }
            long l = Math.max(0L, Math.min((long)this.len, n));
            long skipped = this.is.skip(l);
            this.len = (int)((long)this.len - skipped);
            return skipped;
        }

        @Override
        public void close() throws IOException {
            StreamUtil.close(this.is);
            super.close();
        }
    }
}

