/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci;

import de.bos_bremen.ci.BRun;
import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.FRun;
import de.bos_bremen.ci.FSource;
import de.bos_bremen.ci.SRun;
import de.bos_bremen.ci.SSource;
import de.bos_bremen.ci.Source;
import java.io.IOException;
import java.io.InputStream;

public class Run {
    public static final int INDEF_LEN = -1;
    private static final int EOC_LEN = 2;
    protected final Source source;
    protected int pos;
    protected Byte cache;

    protected Run(Source _source, int _pos) {
        this.source = _source;
        this.pos = _pos;
    }

    public static Run create(Source source) {
        return Run.create(source, 0);
    }

    public static Run create(Source source, int off) {
        if (source instanceof BSource) {
            return new BRun((BSource)source, off);
        }
        if (source instanceof FSource) {
            return new FRun((FSource)source, off);
        }
        if (source instanceof SSource) {
            return new SRun((SSource)source, off);
        }
        return null;
    }

    public Source getSource() {
        return this.source;
    }

    public int pos() {
        return this.pos;
    }

    public byte next() {
        if (this.cache != null) {
            byte result = this.cache;
            this.cache = null;
            ++this.pos;
            return result;
        }
        return this.source.getAbs(this.pos++);
    }

    public byte[] next(int len) {
        if (len == -1) {
            len = this.getEOCPosition() - this.pos - 2;
            byte[] bytes = this.next(len);
            this.skip(2);
            return bytes;
        }
        if (len > 0 && this.cache != null) {
            byte[] buf = new byte[len];
            buf[0] = this.cache;
            this.cache = null;
            ++this.pos;
            int i = this.pos;
            this.pos += --len;
            this.source.getAbs(buf, 1, i, len);
            return buf;
        }
        int i = this.pos;
        this.pos += len;
        return this.source.getAbs(i, len);
    }

    private int getEOCPosition() {
        int currentPos = this.pos;
        byte b1 = 1;
        byte b2 = 1;
        while (b1 != 0 || b2 != 0) {
            b1 = b2;
            b2 = this.source.getAbs(currentPos++, 1)[0];
        }
        return currentPos;
    }

    public int readLength() {
        byte b = this.next();
        if (this.isIndefiniteLengthForm(b)) {
            return -1;
        }
        if (this.isShortLengthForm(b)) {
            return b & 0xFF;
        }
        int count = b & 0x7F;
        if (count > 4) {
            throw new IllegalArgumentException("DER length more than 4 bytes: " + count);
        }
        int result = 0;
        for (int i = 0; i < count; ++i) {
            result <<= 8;
            result += this.next() & 0xFF;
        }
        return result;
    }

    private boolean isIndefiniteLengthForm(byte b) {
        return b == -128;
    }

    private boolean isShortLengthForm(byte b) {
        return (b & 0xFFFFFF80) != -128;
    }

    public byte get() {
        if (this.cache != null) {
            return this.cache;
        }
        this.cache = this.source.getAbs(this.pos);
        return this.cache;
    }

    public void skip(int len) {
        if (len == -1) {
            len = this.getEOCPosition() - this.pos;
        }
        if (len > 0 && this.cache != null) {
            this.cache = null;
            --len;
        }
        this.pos += len;
    }

    public InputStream stream(int len) throws IOException {
        if (len == -1) {
            int eocPos = this.getEOCPosition();
            len = eocPos - this.pos - 2;
            InputStream stream = this.source.contentAsInputStream(this.pos, len);
            this.skip(2);
            return stream;
        }
        return this.source.contentAsInputStream(this.pos, len);
    }
}

