/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISO8601Format
extends DateFormat {
    private static final Logger LOGGER = LoggerFactory.getLogger(ISO8601Format.class);
    private static final long serialVersionUID = 1L;
    public static final int MINLENGTH = 8;
    public static final int MAXLENGTH = 34;
    private boolean timezoneWithColon;
    private boolean forceMillis;

    public ISO8601Format() {
        this(Locale.getDefault());
    }

    public ISO8601Format(boolean _forceMillis, boolean _timezoneWithColon) {
        this(Locale.getDefault());
        this.forceMillis = _forceMillis;
        this.timezoneWithColon = _timezoneWithColon;
    }

    public ISO8601Format(Locale local, boolean _forceMillis, boolean _timezoneWithColon) {
        this(local);
        this.forceMillis = _forceMillis;
        this.timezoneWithColon = _timezoneWithColon;
    }

    public ISO8601Format(TimeZone zone, boolean _forceMillis, boolean _timezoneWithColon) {
        this(zone);
        this.forceMillis = _forceMillis;
        this.timezoneWithColon = _timezoneWithColon;
    }

    public ISO8601Format(TimeZone zone, Locale local, boolean _forceMillis, boolean _timezoneWithColon) {
        this(zone, local);
        this.forceMillis = _forceMillis;
        this.timezoneWithColon = _timezoneWithColon;
    }

    public ISO8601Format(Locale local) {
        this(TimeZone.getDefault(), local);
    }

    public ISO8601Format(TimeZone zone) {
        this(zone, Locale.getDefault());
    }

    public ISO8601Format(TimeZone zone, Locale local) {
        this.setCalendar(Calendar.getInstance(zone, local));
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        if (text.length() < 8) {
            throw new NumberFormatException("text is too short (" + text.length() + " : " + text + ")");
        }
        int i = pos.getIndex();
        try {
            int field = Integer.valueOf(text.substring(i, i + 4));
            this.calendar.set(1, field);
            if (text.charAt(i += 4) == '-') {
                ++i;
            }
            field = Integer.valueOf(text.substring(i, i + 2)) - 1;
            this.calendar.set(2, field);
            if (text.charAt(i += 2) == '-') {
                ++i;
            }
            field = Integer.valueOf(text.substring(i, i + 2));
            this.calendar.set(5, field);
            if ((i += 2) < text.length()) {
                if (text.charAt(i) == 'T' || text.charAt(i) == ' ') {
                    ++i;
                }
                field = Integer.valueOf(text.substring(i, i + 2));
                this.calendar.set(11, field);
                if (text.charAt(i += 2) == ':') {
                    ++i;
                }
                field = Integer.valueOf(text.substring(i, i + 2));
                this.calendar.set(12, field);
                int secs = 0;
                if ((i += 2) < text.length()) {
                    if (text.charAt(i) == ':') {
                        ++i;
                    }
                    secs = Integer.valueOf(text.substring(i, i + 2));
                    i += 2;
                }
                this.calendar.set(13, secs);
                int ms = 0;
                if (text.charAt(i) == '.') {
                    int i1;
                    for (i1 = ++i; i1 < text.length() && Character.isDigit(text.charAt(i1)); ++i1) {
                    }
                    String m = text.substring(i, i1);
                    while (m.length() < 3) {
                        m = m + '0';
                    }
                    if (m.length() > 3) {
                        m = m.substring(0, 3);
                    }
                    ms = Integer.parseInt(m);
                    i = i1;
                }
                this.calendar.set(14, ms);
                if (i < text.length()) {
                    int offset = 0;
                    if (text.indexOf("GMT", i) == i) {
                        i += 3;
                    }
                    if (text.charAt(i) == 'Z') {
                        ++i;
                    } else if (text.charAt(i) == '-' || text.charAt(i) == '+') {
                        int sign = text.charAt(i) == '-' ? -1 : 1;
                        int offset_h = Integer.valueOf(text.substring(++i, i + 2));
                        if (text.charAt(i += 2) == ':') {
                            ++i;
                        }
                        int offset_min = Integer.valueOf(text.substring(i, i + 2));
                        i += 2;
                        offset = sign * (offset_h * 60 + offset_min) * 60000;
                    } else {
                        throw new NumberFormatException("no time zone at index " + i + " : " + text);
                    }
                    this.calendar.add(14, this.calendar.get(15) + this.calendar.get(16) - offset);
                }
            } else {
                this.calendar.set(11, 0);
                this.calendar.set(12, 0);
                this.calendar.set(13, 0);
                this.calendar.set(14, 0);
            }
        }
        catch (NumberFormatException ex) {
            pos.setErrorIndex(i);
            LOGGER.error("String is not formatted appropriately for conversion to a number.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            pos.setErrorIndex(i);
            LOGGER.error("Cannot convert string to number.", (Throwable)ex);
            NumberFormatException nfe = new NumberFormatException(ex.getMessage());
            nfe.initCause(ex);
            throw nfe;
        }
        finally {
            pos.setIndex(i);
        }
        return this.calendar.getTime();
    }

    @Override
    public StringBuffer format(Date date, StringBuffer sbuf, FieldPosition fieldPosition) {
        int offset;
        if (date == null) {
            return sbuf;
        }
        this.calendar.setTimeInMillis(date.getTime());
        sbuf.append(new DecimalFormat("0000").format(this.calendar.get(1)));
        sbuf.append('-');
        sbuf.append(new DecimalFormat("00").format((long)this.calendar.get(2) + 1L));
        sbuf.append('-');
        sbuf.append(new DecimalFormat("00").format(this.calendar.get(5)));
        sbuf.append('T');
        sbuf.append(new DecimalFormat("00").format(this.calendar.get(11)));
        sbuf.append(':');
        sbuf.append(new DecimalFormat("00").format(this.calendar.get(12)));
        sbuf.append(':');
        sbuf.append(new DecimalFormat("00").format(this.calendar.get(13)));
        if (this.forceMillis || this.calendar.get(14) > 0) {
            sbuf.append('.');
            sbuf.append(new DecimalFormat("000").format(this.calendar.get(14)));
        }
        if ((offset = this.calendar.get(15) + this.calendar.get(16)) == 0) {
            sbuf.append('Z');
        } else {
            sbuf.append(new DecimalFormat("+00;-00").format(offset / 3600000));
            if (this.timezoneWithColon) {
                sbuf.append(':');
            }
            sbuf.append(new DecimalFormat("00").format(Math.abs(offset) % 3600000 / 60000));
        }
        return sbuf;
    }
}

