/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci;

import de.bos_bremen.ci.Hex;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class HexOutputStream
extends OutputStream {
    private final Writer out;
    private final boolean spaces;
    private final boolean linewrap;
    private int position;
    private boolean first;

    public HexOutputStream(Writer _out) {
        this(_out, false, true);
    }

    public HexOutputStream(Writer _out, boolean _linewrap, boolean _spaces) {
        this.out = _out;
        this.linewrap = _linewrap;
        this.spaces = _spaces;
        this.first = true;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.first) {
            if (this.spaces) {
                if (this.position == 16) {
                    this.position = 0;
                    this.out.write(this.linewrap ? 10 : 32);
                } else if (this.position != 0) {
                    this.out.write(32);
                }
            } else if (this.linewrap && this.position == 16) {
                this.out.write(10);
            }
        }
        byte hi = (byte)((b & 0xFF & 0xF0) >>> 4);
        byte lo = (byte)(b & 0xF);
        this.out.write(Hex.HEX[hi]);
        this.out.write(Hex.HEX[lo]);
        ++this.position;
        if (this.position == 16) {
            this.position = 0;
            if (this.linewrap) {
                this.out.write(10);
            }
        }
        this.first = false;
    }

    @Override
    public void write(byte[] _buf, int off, int len) throws IOException {
        boolean breaks;
        if (_buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > _buf.length || len < 0 || off + len > _buf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int lenLeft = len - (16 - this.position);
        char[] buf = new char[len * 3];
        int i = 0;
        int j = 0;
        if (!this.first) {
            if (this.spaces) {
                if (this.position == 16) {
                    this.position = 0;
                    buf[j++] = this.linewrap ? 10 : 32;
                } else if (this.position != 0) {
                    buf[j++] = 32;
                }
            } else if (this.linewrap && this.position == 16) {
                buf[j++] = 10;
            }
        }
        this.first = false;
        boolean bl = breaks = this.linewrap && (this.position + len) / 16 + lenLeft / 16 != 0;
        while (i < len) {
            byte b = _buf[off + i++];
            byte hi = (byte)((b & 0xFF & 0xF0) >>> 4);
            byte lo = (byte)(b & 0xF);
            buf[j++] = Hex.HEX[hi];
            buf[j++] = Hex.HEX[lo];
            if (i >= len) continue;
            ++this.position;
            if (breaks && this.position == 16) {
                this.position = 0;
                buf[j++] = 10;
                continue;
            }
            if (!this.spaces) continue;
            buf[j++] = 32;
        }
        this.position = lenLeft % 16;
        this.out.write(buf, 0, j);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        this.first = true;
        this.position = 0;
    }
}

