/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci;

import de.governikus.CompInfo.ComponentInfo;

public class Hex {
    public static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final int LINESIZE = 16;
    private static final String componentInfoFileName = "ci.version";
    private static ComponentInfo ci = new ComponentInfo("ci.version");

    public static String dump(byte[] data) {
        if (data == null) {
            return "";
        }
        return Hex.dump(data, 0, data.length);
    }

    public static String dump(byte[] data, int offset, int len) {
        if (data == null) {
            return "null";
        }
        char[] ascii = new char[16];
        StringBuilder out = new StringBuilder(256);
        int i = offset;
        while (i < offset + len) {
            out.append(Hex.hexify(i >>> 8 & 0xFF));
            out.append(Hex.hexify(i & 0xFF));
            out.append(":  ");
            int j = 0;
            while (j < 16) {
                if (i < data.length) {
                    int b = data[i] & 0xFF;
                    out.append(Hex.hexify(b)).append(' ');
                    ascii[j] = b < 32 ? 46 : (b > 127 ? 46 : (char)b);
                } else {
                    out.append("   ");
                    ascii[j] = 32;
                }
                ++j;
                ++i;
            }
            out.append(' ').append(ascii).append("\n");
        }
        return out.toString();
    }

    public static String hexify(byte[] data) {
        return Hex.hexify(data, false);
    }

    public static String hexify(byte[] data, int _offset, int _length) {
        return Hex.hexify(data, _offset, _length, false);
    }

    public static String hexify(byte[] data, boolean linewrap) {
        return Hex.hexify(data, linewrap, true);
    }

    public static String hexify(byte[] data, int _offset, int _length, boolean linewrap) {
        return Hex.hexify(data, _offset, _length, linewrap, true);
    }

    public static String hexify(byte[] data, boolean linewrap, boolean space) {
        return Hex.hexify(data, 0, data == null ? 0 : data.length, linewrap, space);
    }

    public static String hexify(byte[] data, int _offset, int _length, boolean linewrap, boolean space) {
        if (data == null) {
            return "null";
        }
        StringBuilder out = new StringBuilder(256);
        if (_length > 0) {
            out.append(HEX[data[_offset] >> 4 & 0xF]);
            out.append(HEX[data[_offset] & 0xF]);
        }
        int count = _offset + _length;
        for (int i = _offset + 1; i < count; ++i) {
            if (linewrap && i % 16 == 0) {
                out.append('\n');
            } else if (i < count && space) {
                out.append(' ');
            }
            out.append(HEX[data[i] >> 4 & 0xF]);
            out.append(HEX[data[i] & 0xF]);
        }
        return out.toString();
    }

    public static String hexify(int val) {
        return "" + HEX[(val & 0xFF & 0xF0) >>> 4] + HEX[val & 0xF];
    }

    public static String hexifyShort(byte a, byte b) {
        return Hex.hexifyShort(a & 0xFF, b & 0xFF);
    }

    public static String hexifyShort(int val) {
        return "" + HEX[(val & 0xFFFF & 0xF000) >>> 12] + HEX[(val & 0xFFF & 0xF00) >>> 8] + HEX[(val & 0xFF & 0xF0) >>> 4] + HEX[val & 0xF];
    }

    public static String hexifyShort(int a, int b) {
        return Hex.hexifyShort(((a & 0xFF) << 8) + (b & 0xFF));
    }

    public static byte[] parseHexString(String _hexBytes) {
        if (_hexBytes == null) {
            return null;
        }
        int offset = 2;
        if (_hexBytes.length() > 2 && _hexBytes.charAt(2) == ' ') {
            offset = 3;
        }
        int resultLength = offset == 2 ? _hexBytes.length() / offset : (_hexBytes.length() + 1) / offset;
        byte[] result = new byte[resultLength];
        for (int i = 0; i < _hexBytes.length(); i += offset) {
            String toParse = _hexBytes.substring(i, i + 2);
            result[i / offset] = (byte)Integer.parseInt(toParse, 16);
        }
        return result;
    }

    public static byte[] parseHexString(String _hexBytes, int _off, int _len) {
        int byteLen = 2;
        int off = _off;
        int len = _len;
        if (off + len > 2 && _hexBytes.charAt(off + 2) == ' ') {
            byteLen = 3;
        }
        int resultLength = byteLen == 2 ? len / byteLen : (len + 1) / byteLen;
        byte[] result = new byte[resultLength];
        for (int i = 0; i < len; i += byteLen) {
            String toParse = _hexBytes.substring(off + i, off + i + 2);
            result[i / byteLen] = (byte)Integer.parseInt(toParse, 16);
        }
        return result;
    }

    private static void binarify(byte _b, StringBuilder _sb) {
        _sb.append((_b & 0x80) == 128 ? (char)'1' : '0');
        _sb.append((_b & 0x40) == 64 ? (char)'1' : '0');
        _sb.append((_b & 0x20) == 32 ? (char)'1' : '0');
        _sb.append((_b & 0x10) == 16 ? (char)'1' : '0');
        _sb.append((_b & 8) == 8 ? (char)'1' : '0');
        _sb.append((_b & 4) == 4 ? (char)'1' : '0');
        _sb.append((_b & 2) == 2 ? (char)'1' : '0');
        _sb.append((_b & 1) == 1 ? (char)'1' : '0');
    }

    public static String binarify(byte[] data, int _offset, int _length, boolean linewrap, boolean space) {
        if (data == null) {
            return "null";
        }
        if (_offset + _length > data.length) {
            throw new ArrayIndexOutOfBoundsException("offet + length exeed data length");
        }
        StringBuilder out = new StringBuilder(256);
        if (_length > 0) {
            Hex.binarify(data[_offset], out);
        }
        int count = _offset + _length;
        for (int i = _offset + 1; i < count; ++i) {
            if (linewrap && i % 16 == 0) {
                out.append('\n');
            } else if (i < count && space) {
                out.append(' ');
            }
            Hex.binarify(data[i], out);
        }
        return out.toString();
    }

    public static String replace(String s, String _placeholder, String _replacement) {
        int index;
        if (s == null) {
            return null;
        }
        if (_placeholder == null) {
            return s;
        }
        if (_replacement == null) {
            _replacement = "";
        }
        if ((index = s.indexOf(_placeholder)) != -1) {
            s = s.substring(0, index) + _replacement + s.substring(index + _placeholder.length());
        }
        return s;
    }

    public static String replaceAll(String s, String _placeholder, String _replacement) {
        if (s == null) {
            return null;
        }
        if (_placeholder == null) {
            return s;
        }
        if (_replacement == null) {
            _replacement = "";
        }
        int index = s.indexOf(_placeholder);
        while (index != -1) {
            s = s.substring(0, index) + _replacement + s.substring(index + _placeholder.length());
            index = s.indexOf(_placeholder);
        }
        return s;
    }

    public static String replace(String s, int _placeholder, String _replacement) {
        int index;
        if (s == null) {
            return null;
        }
        if (_replacement == null) {
            _replacement = "";
        }
        if ((index = s.indexOf(_placeholder)) != -1) {
            s = s.substring(0, index) + _replacement + s.substring(index + 1);
        }
        return s;
    }

    public static String replaceAll(String s, int _placeholder, String _replacement) {
        if (s == null) {
            return null;
        }
        if (_replacement == null) {
            _replacement = "";
        }
        int index = s.indexOf(_placeholder);
        while (index != -1) {
            s = s.substring(0, index) + _replacement + s.substring(index + 1);
            index = s.indexOf(_placeholder, index + _replacement.length());
        }
        return s;
    }

    public static String replace(String s, String _placeholder, int _replacement) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(_placeholder);
        if (index != -1) {
            s = s.substring(0, index) + Character.toString((char)_replacement) + s.substring(index + _placeholder.length());
        }
        return s;
    }

    public static String replaceAll(String s, String _placeholder, int _replacement) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(_placeholder);
        while (index != -1) {
            s = s.substring(0, index) + Character.toString((char)_replacement) + s.substring(index + _placeholder.length());
            index = s.indexOf(_placeholder);
        }
        return s;
    }

    public static String getComponentVersion() {
        String ver = ci.getComponentVersion();
        if (ver != null) {
            return ver;
        }
        return "Untagged Version";
    }

    public static String getRevision() {
        String rev = ci.getComponentRevision();
        if (rev != null) {
            return rev;
        }
        return "No revision available";
    }

    public static String getComponentName() {
        return ci.getComponentName();
    }
}

