/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci;

import de.bos_bremen.ci.Flattable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlattableUtil {
    private static final Set<Locale> availableLocales;
    private static final Logger LOGGER;

    public static DateFormat newDateFormat(ResourceBundle bundle, boolean shortPattern) {
        String pattern = null;
        Locale locale = bundle.getLocale();
        LOGGER.trace("Returned locale of this resource bundle: {}", (Object)locale);
        if (Locale.ROOT.equals(locale)) {
            locale = Locale.GERMAN;
            LOGGER.trace("Is ROOT locale, setting to Locale.GERMAN: {}", (Object)locale);
        } else if (locale == null || !availableLocales.contains(locale)) {
            locale = Locale.getDefault();
            LOGGER.debug("Locale is null or not available, using fallback Locale.getDefault(): {}", (Object)locale);
        }
        pattern = shortPattern ? bundle.getString("dateformat.pattern.short") : bundle.getString("dateformat.pattern.long");
        return new SimpleDateFormat(pattern, locale);
    }

    public static DateFormat newDateFormat(Locale locale, boolean shortPattern) {
        ResourceBundle bundle = ResourceBundle.getBundle(Flattable.class.getName(), locale);
        String pattern = shortPattern ? bundle.getString("dateformat.pattern.short") : bundle.getString("dateformat.pattern.long");
        return new SimpleDateFormat(pattern, locale);
    }

    static {
        LOGGER = LoggerFactory.getLogger(FlattableUtil.class);
        availableLocales = new HashSet<Locale>(Arrays.asList(Locale.getAvailableLocales()));
    }
}

