/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;

public class BSource
extends Source {
    private Map<String, byte[]> fingerprintCache = new HashMap<String, byte[]>();
    private final byte[] bytes;

    public BSource(File _file) throws IOException {
        try (FileInputStream is = new FileInputStream(_file);){
            this.bytes = StreamUtil.read(is);
        }
    }

    public BSource(InputStream _is) throws IOException {
        this(StreamUtil.read(_is));
    }

    public BSource(byte[] _bytes) {
        this.bytes = _bytes;
    }

    @Override
    public byte getAbs(int _index) {
        if (_index >= this.bytes.length) {
            return -1;
        }
        return this.bytes[_index];
    }

    @Override
    public byte[] getAbs(int _off, int _len) {
        byte[] result = new byte[_len];
        this.getAbs(result, 0, _off, _len);
        return result;
    }

    @Override
    public void getAbs(byte[] _buf, int _off, int _off2, int _len) {
        System.arraycopy(this.bytes, _off2, _buf, _off, _len);
    }

    @Override
    public InputStream contentAsInputStream(int offset, int length) {
        if (offset >= this.bytes.length) {
            throw new IndexOutOfBoundsException("Offset too large " + offset);
        }
        length = Math.min(length, this.bytes.length - offset);
        return new ByteArrayInputStream(this.bytes, offset, length);
    }

    @Override
    public String asHexedString(int _off, int _len) {
        return Hex.hexify(this.bytes, _off, _len);
    }

    @Override
    public String asUFT8String(int _off, int _len) {
        return this.toCharBuffer("UTF-8", _off, _len).toString();
    }

    @Override
    public CharBuffer toCharBuffer(String encoding) {
        ByteBuffer bb = ByteBuffer.wrap(this.bytes);
        if (encoding == null) {
            return bb.asCharBuffer();
        }
        return Charset.forName(encoding).decode(bb);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public CharBuffer toCharBuffer(String encoding, int _off, int _len) {
        ByteBuffer bb = ByteBuffer.wrap(this.bytes, _off, _len);
        if (encoding == null) {
            return bb.asCharBuffer();
        }
        return Charset.forName(encoding).decode(bb);
    }

    @Override
    public void write(OutputStream os, int _off, int _len) throws IOException {
        os.write(this.bytes, _off, _len);
    }

    @Override
    public void write(Signature _sig, int _off, int _len) throws IOException, SignatureException {
        _sig.update(this.bytes, _off, _len);
    }

    @Override
    public byte[] getFingerprint(String _mdType, int _off, int _len) {
        try {
            String key = _mdType + "_" + _off + "_" + _len;
            if (this.fingerprintCache.containsKey(key)) {
                return this.fingerprintCache.get(key);
            }
            MessageDigest md = MessageDigest.getInstance(_mdType);
            md.update(this.getAbs(_off, _len));
            byte[] digest = md.digest();
            this.fingerprintCache.put(key, digest);
            return digest;
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }
}

