/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.governikus.utils.secutils.SecurityUtils;
import de.osci.osci12.OSCIException;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messageparts.ProcessCardParser2;
import de.osci.osci12.messagetypes.StoredMessage;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Role;
import de.osci.osci12.soapheader.CustomHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CEConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCEOSCI(File _osciCECoCo) throws IOException {
        LineNumberReader lnr = new LineNumberReader(new FileReader(_osciCECoCo));
        try {
            String line = lnr.readLine();
            while (line != null) {
                if (line.indexOf("GOV2_CE_PROCESSCARD") != -1) {
                    boolean bl = true;
                    return bl;
                }
                line = lnr.readLine();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                lnr.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static StoredMessage enableOSCI(Object _source) throws SAXException, IOException, ParserConfigurationException, NoSuchAlgorithmException, OSCIException {
        if (_source == null) {
            return null;
        }
        if (_source instanceof File) {
            if (!((File)_source).exists()) {
                return null;
            }
            FileInputStream is = new FileInputStream((File)_source);
            StoredMessage sm = StoredMessage.loadMessage((InputStream)is);
            CEConverter.extractGOV2_CE_PROCESSCARD(sm);
            return sm;
        }
        if (_source instanceof OSCIMessageEssence) {
            OSCIMessageEssence essense = (OSCIMessageEssence)_source;
            StoredMessage sm = new StoredMessage(essense.messageType);
            for (Role r : essense.roles) {
                if (!(r instanceof Addressee)) continue;
                sm.addressee = (Addressee)r;
                break;
            }
            for (Role r : essense.roles) {
                if (!(r instanceof Originator)) continue;
                sm.originator = (Originator)r;
                break;
            }
            if (essense.messageType == 128) {
                sm.processCardBundleReply = essense.processCard;
            } else {
                sm.processCardBundles = new ProcessCardBundle[]{essense.processCard};
            }
            sm.contentContainer.putAll(essense.cocos);
            sm.encryptedData.putAll(essense.endas);
            return sm;
        }
        throw new IllegalArgumentException("param is neither an OSCI message file nor a OSCIMessageEssence instance");
    }

    private static void extractGOV2_CE_PROCESSCARD(StoredMessage _sm) throws SAXException, IOException, ParserConfigurationException {
        String head = CEConverter.extractGOV2_CE_PROCESSCARDFromCustomHeaders(_sm);
        if (head == null) {
            return;
        }
        _sm.processCardBundles = new ProcessCardBundle[]{CEConverter.parseProcessCardBundles(head)};
        _sm.messageType = 48;
    }

    public static String extractGOV2_CE_PROCESSCARDFromCustomHeaders(StoredMessage _sm) {
        String head = null;
        Iterator iter = _sm.customHeaders.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            CustomHeader ch = (CustomHeader)o;
            String s = ch.getData();
            if (s.indexOf("GOV2_CE_PROCESSCARD") < 0) continue;
            head = s;
            iter.remove();
            break;
        }
        if (head != null) {
            head = head.replaceAll("GOV2_CE_PROCESSCARD", "Delivery");
        }
        return head;
    }

    private static ProcessCardBundle parseProcessCardBundles(String head) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SecurityUtils.protectFactoryAgainstXXE((SAXParserFactory)saxFactory);
        saxFactory.setNamespaceAware(true);
        SAXParser parser = saxFactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        SecurityUtils.protectReaderAgainstXXE((XMLReader)reader);
        reader.setFeature("http://xml.org/sax/features/validation", false);
        ProcessCardParser2 pcp = new ProcessCardParser2(reader);
        reader.setContentHandler((ContentHandler)((Object)pcp));
        if (head.indexOf("xmlns:osci") < 0) {
            head = head.substring(0, head.indexOf("Id=")) + "xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:osci=\"http://www.osci.de/2002/04/osci\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " + head.substring(head.indexOf("Id="), head.length());
        }
        reader.parse(new InputSource(new StringReader(head)));
        return pcp.getProcBundle();
    }

    public static class OSCIMessageEssence {
        public final Map<String, ContentContainer> cocos = new HashMap<String, ContentContainer>();
        public final Map<String, EncryptedDataOSCI> endas = new HashMap<String, EncryptedDataOSCI>();
        public final List<Role> roles = new ArrayList<Role>();
        private ProcessCardBundle processCard;
        private int messageType;
    }
}

