/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci.criteria;

import de.governikus.csl.osci.OSCIContainer;
import de.governikus.csl.osci.OSCIEncryptedData;
import de.governikus.csl.osci.OSCIMessage;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.OSCIDocumentValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.criteria.AbstractObjectValidationCriterion;
import java.util.ArrayList;
import java.util.List;

public class CheckForEncryptedDatas
extends AbstractObjectValidationCriterion<OSCIContainer, OSCIDocumentValidationResult> {
    public void validate(OSCIContainer document, OSCIDocumentValidationResult result, DocumentValidationContext documentValidationContext) {
        ArrayList<ValidationMessageCode> messages = new ArrayList<ValidationMessageCode>();
        for (OSCIContainer innerContainer : document.getContainedObjectsToValidate()) {
            if (!(innerContainer.getOSCIContainerData() instanceof OSCIEncryptedData)) continue;
            String messageCode = document.getOSCIContainerData() instanceof OSCIMessage ? "osci_message_contains_encrypted_datas" : "osci_coco_contains_encrypted_datas";
            messages.add(SVPFactory.createMessageCode((String)messageCode, (Object[])new Object[]{document.getOSCIContainerData().getId(), innerContainer.getOSCIContainerData().getId()}));
        }
        if (!messages.isEmpty()) {
            ValidationResult encDataResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)MinorResult.GENERIC);
            encDataResult.getMessages().addAll(messages);
            List additonalValidationResult = result.getAdditonalValidationResult();
            additonalValidationResult.add(encDataResult);
        }
    }
}

