/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci.criteria;

import de.governikus.csl.osci.OSCIContainer;
import de.governikus.csl.osci.OSCIContainerData;
import de.governikus.csl.osci.OSCIContent;
import de.governikus.csl.osci.OSCIContentContainer;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.OSCIDocumentValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.context.DocumentValidationContext;
import de.governikus.csl.validation.criteria.AbstractObjectValidationCriterion;
import java.util.ArrayList;
import java.util.TreeSet;

public class CheckForDuplicateReferenceIds
extends AbstractObjectValidationCriterion<OSCIContainer, OSCIDocumentValidationResult> {
    public void validate(OSCIContainer document, OSCIDocumentValidationResult result, DocumentValidationContext documentValidationContext) {
        OSCIContainerData containerData = document.getOSCIContainerData();
        if (containerData instanceof OSCIContentContainer) {
            TreeSet<String> refIdSet = new TreeSet<String>();
            for (OSCIContent oSCIContent : ((OSCIContentContainer)containerData).getDuplicateRefIdContentList()) {
                refIdSet.add(oSCIContent.getId());
            }
            if (!refIdSet.isEmpty()) {
                ArrayList<ValidationMessageCode> messages = new ArrayList<ValidationMessageCode>();
                for (String refId : refIdSet) {
                    messages.add(SVPFactory.createMessageCode((String)"osci_coco_contains_duplicate_refids", (Object[])new Object[]{((OSCIContentContainer)containerData).getId(), refId}));
                }
                ValidationResult validationResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE);
                validationResult.getMessages().addAll(messages);
                result.getAdditonalValidationResult().add(validationResult);
            }
        }
    }
}

