/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci.criteria;

import de.governikus.csl.osci.OSCIContent;
import de.governikus.csl.osci.OSCIContentContainer;
import de.governikus.csl.osci.OSCISignature;
import de.governikus.csl.osci.OSCIValidationContext;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.OSCISignatureValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.ValidationCriterion;
import java.util.ArrayList;
import java.util.List;

public class CheckAllContentsSigned
implements ValidationCriterion<OSCISignature, OSCISignatureValidationResult, OSCIValidationContext> {
    public void verify(OSCISignature signatureObject, OSCISignatureValidationResult validationResult, OSCIValidationContext context) {
        OSCIContentContainer osciCoCo = signatureObject.getContentContainer();
        List<OSCIContent> unsignedContentList = osciCoCo.getUnsignedContentList(signatureObject);
        if (unsignedContentList.isEmpty()) {
            validationResult.setAllContentSignedCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_PASSED, (MinorResult)null));
        } else {
            ArrayList<ValidationMessageCode> messages = new ArrayList<ValidationMessageCode>();
            for (OSCIContent content : unsignedContentList) {
                messages.add(SVPFactory.createMessageCode((String)"osci_coco_contains_unsigned_content", (Object[])new Object[]{osciCoCo.getId(), content.getId()}));
            }
            ValidationResult allSignedResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE);
            allSignedResult.getMessages().addAll(messages);
            validationResult.setAllContentSignedCheck(allSignedResult);
        }
    }

    public boolean preconditionsFulfilled(OSCISignature signature, OSCISignatureValidationResult result) {
        return true;
    }

    public boolean isApplicable(OSCISignature signature, OSCISignatureValidationResult result, OSCIValidationContext context) {
        return true;
    }
}

