/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.ISO8601Format;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.SignedData;
import de.bos_bremen.ci.asn1.tsp.SignatureTimeStampToken;
import de.bos_bremen.ci.asn1.tsp.TimeStampResp;
import de.governikus.csl.core.impl.CertificateWrapper;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.Certificate;
import de.governikus.csl.validation.tsp.DefaultTimestampFactory;
import de.governikus.csl.validation.tsp.TSPParser;
import de.governikus.csl.validation.tsp.TimestampFactory;
import de.governikus.csl.validation.tsp.TimestampedObject;
import de.osci.osci12.messageparts.Timestamp;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import java.util.List;

public class ProcessCardTimestamp {
    private String algorithm;
    private Date plainDate;
    private String tsContent;
    private Certificate tsCertificate;
    private AlgorithmManager algorithmManager;

    public ProcessCardTimestamp(Timestamp timestamp, AlgorithmManager algorithmManager) {
        this.algorithmManager = algorithmManager;
        if (timestamp.getAlgorithm() != null && timestamp.getAlgorithm().trim().length() > 0) {
            this.algorithm = timestamp.getAlgorithm();
        }
        this.tsContent = timestamp.getTimeStamp();
        if (this.isPlain()) {
            try {
                this.plainDate = new ISO8601Format().parse(this.tsContent);
            }
            catch (java.text.ParseException p_ex) {
                throw new IllegalArgumentException("Cannot parse '" + this.tsContent + "' as ISO8601 timestamp!");
            }
        } else {
            this.parseCryptographicTimestamp(this.tsContent);
        }
    }

    public boolean isPlain() {
        return this.algorithm == null;
    }

    public Date getDate() {
        return this.plainDate;
    }

    public Certificate getCertificate() {
        return this.tsCertificate;
    }

    private void parseCryptographicTimestamp(String b64Timestamp) {
        byte[] bytes = Base64.getMimeDecoder().decode(b64Timestamp);
        SignatureTimeStampToken stst = null;
        try {
            stst = new SignatureTimeStampToken((Source)new BSource(bytes));
        }
        catch (ParseException ex) {
            try {
                stst = (SignatureTimeStampToken)new TimeStampResp((Source)new BSource(bytes)).getTimeStampToken();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (stst == null || stst.getSignedData() == null) {
            throw new IllegalArgumentException("Cannot parse timestamp as signature timestamp token or timestamp response!");
        }
        TSPParser parser = new TSPParser(this.algorithmManager);
        List timestamps = parser.parse((SignedData)stst.getContent(), null, (TimestampFactory)new DefaultTimestampFactory());
        TimestampedObject timestamp = (TimestampedObject)timestamps.get(0);
        this.plainDate = timestamp.getGenerationTime();
        X509CertificateImpl cert = timestamp.getSigningCertificate();
        if (cert != null) {
            this.tsCertificate = new CertificateWrapper((X509Certificate)cert);
        }
    }
}

