/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.governikus.csl.osci.ProcessCardParser;
import de.governikus.utils.secutils.SecurityUtils;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.MessagePart;
import de.osci.osci12.messageparts.OSCISignature;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messagetypes.AcceptDelivery;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.ProcessDelivery;
import de.osci.osci12.messagetypes.ResponseToFetchDelivery;
import de.osci.osci12.messagetypes.ResponseToForwardDelivery;
import de.osci.osci12.messagetypes.ResponseToMediateDelivery;
import de.osci.osci12.messagetypes.ResponseToStoreDelivery;
import de.osci.osci12.messagetypes.StoredMessage;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class OSCIUtil {
    public static final String PREFIX_REF_CONTENT = "#";
    public static final String PREFIX_REF_ATTACHMENT = "cid:";

    public static ProcessCardBundle getProcessCardBundle(OSCIMessage message) {
        if (message instanceof StoredMessage) {
            int type = ((StoredMessage)message).getMessageType();
            if ((type == 1 || type == 80 || type == 160 || type == 9 || type == 48) && ((StoredMessage)message).getProcessCardBundle() != null) {
                return ((StoredMessage)message).getProcessCardBundle();
            }
            if (type == 128 && ((StoredMessage)message).getProcessCardBundleReply() != null) {
                return ((StoredMessage)message).getProcessCardBundleReply();
            }
            ProcessCardBundle[] processCards = OSCIUtil.getProCardsFromCustomHeader((StoredMessage)message);
            if (processCards != null) {
                return processCards[0];
            }
            throw new IllegalArgumentException("Wrong message type to get a ProcessCardBundle.");
        }
        switch (message.getMessageType()) {
            case 1: {
                return ((AcceptDelivery)message).getProcessCardBundle();
            }
            case 9: {
                return ((ProcessDelivery)message).getProcessCardBundle();
            }
            case 48: {
                return ((ResponseToFetchDelivery)message).getProcessCardBundle();
            }
            case 80: {
                return ((ResponseToForwardDelivery)message).getProcessCardBundle();
            }
            case 160: {
                return ((ResponseToStoreDelivery)message).getProcessCardBundle();
            }
            case 128: {
                return ((ResponseToMediateDelivery)message).getProcessCardBundleReply();
            }
        }
        throw new IllegalArgumentException("Wrong message type to get a ProcessCardBundle.");
    }

    private static ProcessCardBundle[] getProCardsFromCustomHeader(StoredMessage message) {
        String[] ch = message.getCustomHeaders();
        String head = null;
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i].indexOf("GOV2_CE_PROCESSCARD") < 0) continue;
            head = ch[i];
            break;
        }
        if (head != null) {
            try {
                head = head.replaceAll("GOV2_CE_PROCESSCARD", "Delivery");
                return OSCIUtil.parseProcessCardBundles(head);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                return null;
            }
        }
        return null;
    }

    private static ProcessCardBundle[] parseProcessCardBundles(String header) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SecurityUtils.protectFactoryAgainstXXE((SAXParserFactory)saxFactory);
        saxFactory.setNamespaceAware(true);
        SAXParser parser = saxFactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        SecurityUtils.protectReaderAgainstXXE((XMLReader)reader);
        reader.setFeature("http://xml.org/sax/features/validation", false);
        ProcessCardParser pcp = new ProcessCardParser(reader);
        reader.setContentHandler((ContentHandler)((Object)pcp));
        if (header.indexOf("xmlns:osci") < 0) {
            header = header.substring(0, header.indexOf("Id=")) + "xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:osci=\"http://www.osci.de/2002/04/osci\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " + header.substring(header.indexOf("Id="), header.length());
        }
        reader.parse(new InputSource(new StringReader(header)));
        return new ProcessCardBundle[]{pcp.procBundle, pcp.procBundleReply};
    }

    public static List<MessagePart> getReferencesAsList(OSCISignature osciSignature) {
        Map references = osciSignature.getReferences();
        return references.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public static String getDigestMethodAlgorithm(MessagePart osciSigRef, OSCISignature osciSignature) {
        return (String)osciSignature.getDigestMethods().get(osciSigRef.getRefID());
    }

    public static byte[] getDigestValue(MessagePart osciSigRef, OSCISignature osciSignature) {
        return (byte[])osciSignature.getDigests().get(osciSigRef.getRefID());
    }

    public static String getReferencePrefix(MessagePart msgPart) {
        if (msgPart instanceof Attachment) {
            return PREFIX_REF_ATTACHMENT;
        }
        if (msgPart instanceof Content || msgPart instanceof EncryptedDataOSCI) {
            return PREFIX_REF_CONTENT;
        }
        return "";
    }
}

