/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.osci.OSCIData;
import de.governikus.csl.uom.validate.commons.SignedContentPart;
import java.io.IOException;
import java.io.InputStream;

public class OSCISignedContentPart
implements SignedContentPart {
    private String contentName;
    private byte[] digest;
    private DigestAlgorithm digestAlgorithm;
    private OSCIData osciData;

    public OSCISignedContentPart(OSCIData osciData, byte[] digest, DigestAlgorithm digestAlgorithm) {
        this.setContentName(osciData.getId());
        this.digest = digest;
        this.osciData = osciData;
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setContentName(String contentName) {
        this.contentName = contentName;
    }

    public String getContentName() {
        return this.contentName;
    }

    public InputStream getContentPart() throws IllegalArgumentException {
        try {
            return this.osciData.getStream();
        }
        catch (IOException io_ex) {
            throw new IllegalArgumentException(io_ex);
        }
    }

    public String getRefId() {
        return this.osciData.getSignatureId();
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public byte[] getCalculatedDigest() {
        return this.osciData.getDigest(this.digestAlgorithm.getURI());
    }

    public void setCalculatedDigest(byte[] data) {
        this.osciData.setDigest(this.digestAlgorithm.getURI(), data);
    }
}

