/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.governikus.csl.core.impl.BaseSignature;
import de.governikus.csl.osci.OSCIAttachment;
import de.governikus.csl.osci.OSCIAttachmentReference;
import de.governikus.csl.osci.OSCIContent;
import de.governikus.csl.osci.OSCIContentContainer;
import de.governikus.csl.osci.OSCIContentContainerReference;
import de.governikus.csl.osci.OSCIContentData;
import de.governikus.csl.osci.OSCIData;
import de.governikus.csl.osci.OSCISignedContentPart;
import de.governikus.csl.validate.svp.OSCISignatureRole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSCISignature
extends BaseSignature {
    private String name;
    private OSCIContentContainer contentContainer;
    private OSCISignatureRole osciSignatureRole;
    private Map<String, OSCIData> contentMap = new HashMap<String, OSCIData>();
    private List<OSCIContentContainerReference> osciContentContainerRefList = new ArrayList<OSCIContentContainerReference>();
    private List<OSCIContentData> osciContentDataList = new ArrayList<OSCIContentData>();
    private List<OSCIAttachmentReference> osciAttachmentRefList = new ArrayList<OSCIAttachmentReference>();
    private List<OSCIAttachment> osciAttachmentList = new ArrayList<OSCIAttachment>();

    public OSCISignature(String name, OSCIContentContainer contentContainer, OSCISignatureRole role) {
        this.name = name;
        this.contentContainer = contentContainer;
        this.osciSignatureRole = role;
    }

    public OSCIContentContainer getContentContainer() {
        return this.contentContainer;
    }

    public void addContent(OSCIData osciData) {
        this.contentMap.put(osciData.getSignatureId(), osciData);
        if (osciData instanceof OSCIAttachment) {
            this.osciAttachmentList.add((OSCIAttachment)osciData);
        } else if (osciData instanceof OSCIAttachmentReference) {
            this.osciAttachmentRefList.add((OSCIAttachmentReference)osciData);
        } else if (osciData instanceof OSCIContentContainerReference) {
            this.osciContentContainerRefList.add((OSCIContentContainerReference)osciData);
        } else if (osciData instanceof OSCIContentData) {
            this.osciContentDataList.add((OSCIContentData)osciData);
        }
    }

    public OSCIContent getContent(String sigRefId) {
        return this.contentMap.get(sigRefId);
    }

    public List<? extends OSCIContent> getContentList() {
        return new ArrayList<OSCIData>(this.contentMap.values());
    }

    public List<OSCIContentData> getContentDataList() {
        return new ArrayList<OSCIContentData>(this.osciContentDataList);
    }

    public List<OSCIAttachment> getAttachmentList() {
        return new ArrayList<OSCIAttachment>(this.osciAttachmentList);
    }

    public List<OSCIAttachmentReference> getAttachmentReferenceList() {
        return new ArrayList<OSCIAttachmentReference>(this.osciAttachmentRefList);
    }

    public List<OSCIContentContainerReference> getContentContainerReferenceList() {
        return new ArrayList<OSCIContentContainerReference>(this.osciContentContainerRefList);
    }

    public String getName() {
        return this.name;
    }

    public OSCISignatureRole getOSCISignatureRole() {
        return this.osciSignatureRole;
    }

    public List<OSCISignedContentPart> getSignedContentParts() {
        return super.getSignedContentParts();
    }
}

