/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.osci;

import de.governikus.csl.osci.OSCIContainer;
import de.governikus.csl.osci.OSCIDataExtractor;
import de.governikus.csl.osci.OSCIParser;
import de.governikus.csl.osci.OSCISignature;
import de.governikus.csl.osci.OSCIValidationContext;
import de.governikus.csl.osci.criteria.CheckAllContentsSigned;
import de.governikus.csl.osci.criteria.CheckForDuplicateReferenceIds;
import de.governikus.csl.osci.criteria.CheckForEncryptedDatas;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.utils.MagicBytes;
import de.governikus.csl.validate.svp.ContentSignatureValidationResult;
import de.governikus.csl.validate.svp.OSCIDocumentValidationResult;
import de.governikus.csl.validate.svp.OSCISignatureValidationResult;
import de.governikus.csl.validation.AbstractContainerDocumentPlugin;
import de.governikus.csl.validation.ObjectValidationCriterion;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.dataExtractor.DefaultContentSignatureDataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginType(id=Plugin.PluginID.VALIDATE_OSCI, type=ValidatePlugin.class)
public class OSCIPlugin
extends AbstractContainerDocumentPlugin<OSCIContainer, OSCISignature, OSCIDocumentValidationResult, OSCISignatureValidationResult, OSCIValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSCIPlugin.class);
    private static DataExtractor<? super OSCIContainer, ? super OSCIDocumentValidationResult> docDataExtractor;
    private static DataExtractor<? super OSCISignature, ? super OSCISignatureValidationResult> sigDataExtractor;

    public OSCIPlugin() {
        super(OSCISignature.class, OSCIValidationContext.class);
    }

    public boolean supportsMimeType(String mimetype) {
        return false;
    }

    public MagicBytes getMagicBytesOfDocumentFormat() {
        return MagicBytes.MAGIC_BYTES_OSCI;
    }

    public OSCIContainer parseDocument(SignedData doc, TempDataManager tempDataManager) throws ValidatePluginException {
        try {
            OSCIParser parser = new OSCIParser(this, tempDataManager, this.configuration);
            return parser.loadDocument(doc);
        }
        catch (ValidatePluginException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValidatePluginException((ValidatePlugin)this, "Can't parse document", (Throwable)e);
        }
    }

    public static List<ValidationCriterion<? super OSCISignature, ? super OSCISignatureValidationResult, ? super OSCIValidationContext>> getAllKnownSignatureValidationCriteria() {
        ArrayList<ValidationCriterion<? super OSCISignature, ? super OSCISignatureValidationResult, ? super OSCIValidationContext>> criterionList = new ArrayList<ValidationCriterion<? super OSCISignature, ? super OSCISignatureValidationResult, ? super OSCIValidationContext>>();
        criterionList.add(new CheckAllContentsSigned());
        return criterionList;
    }

    public static List<ObjectValidationCriterion<? super OSCIContainer, ? super OSCIDocumentValidationResult>> getAllKnownDocumentValidationCriteria() {
        ArrayList<ObjectValidationCriterion<? super OSCIContainer, ? super OSCIDocumentValidationResult>> criterionList = new ArrayList<ObjectValidationCriterion<? super OSCIContainer, ? super OSCIDocumentValidationResult>>();
        criterionList.add((ObjectValidationCriterion<? super OSCIContainer, ? super OSCIDocumentValidationResult>)new CheckForEncryptedDatas());
        criterionList.add((ObjectValidationCriterion<? super OSCIContainer, ? super OSCIDocumentValidationResult>)new CheckForDuplicateReferenceIds());
        return criterionList;
    }

    protected OSCIDocumentValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        OSCIDocumentValidationResult res = new OSCIDocumentValidationResult();
        res.setObjectTypeID(Plugin.PluginID.VALIDATE_OSCI.getID());
        return res;
    }

    protected OSCISignatureValidationResult createSignatureValidationResultStructure() {
        return new OSCISignatureValidationResult();
    }

    public OSCIValidationContext createContext(OSCISignature signature, ValidationPolicyType policy) {
        return new OSCIValidationContext(policy);
    }

    public synchronized DataExtractor<? super OSCIContainer, ? super OSCIDocumentValidationResult> getDocumentDataExtractor() {
        if (docDataExtractor == null) {
            docDataExtractor = new OSCIDataExtractor();
        }
        return docDataExtractor;
    }

    public synchronized DataExtractor<? super OSCISignature, ? super OSCISignatureValidationResult> getSignatureDataExtractor() {
        if (sigDataExtractor == null) {
            sigDataExtractor = new DefaultContentSignatureDataExtractor<OSCISignature, OSCISignatureValidationResult>(){

                public void extractData(OSCISignature source, OSCISignatureValidationResult destination) {
                    super.extractData((Signature)source, (ContentSignatureValidationResult)destination);
                    destination.setOsciSignatureRole(source.getOSCISignatureRole());
                }
            };
        }
        return sigDataExtractor;
    }
}

